<?php
   $theme_options = get_option('theme_options');  
    $btn_text = 'Read More';
  if(isset($theme_options['blog_btn_text']) && !empty($theme_options['blog_btn_text']))
  {
    $btn_text = $theme_options['blog_btn_text'];
  }
   ?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
   <div class="gt-blog-post">
      <div class="gt-post-media">
         <?php  the_post_thumbnail(); ?>
      </div>
      <?php
         $archive_year  = get_the_time( 'Y' ); 
         $archive_month = get_the_time( 'm' ); 
         $archive_day   = get_the_time( 'd' ); 
      ?>
      <div class="gt-blog-contain">

        <?php if(has_post_thumbnail()){ ?>
         <div class="gt-post-date">
            <a href="<?php echo esc_url( get_day_link($archive_year, $archive_month, $archive_day ) ); ?>">
            <span><?php echo esc_html( get_the_date()); ?></span></a>
         </div>
        <?php } ?>

        <?php if(!is_single()) {

             if(is_sticky() && !is_single())
             {
            ?>
                <span class="gt-sticky-post-label"><i class="fa fa-star" aria-hidden="true"></i><?php echo esc_html__('Featured', 'yog') ?></span>
          <?php } ?>
        <?php } ?>

         <div class="gt-post-meta">

            <ul>
               <li class="pt-post-tag">
                 <?php
                    $i =0;
                    $categories = get_the_category( get_the_ID() );
                    foreach( $categories as $category ) {
                      if($i==0)
                      {
                      ?>
                     <a href="<?php echo esc_url( get_category_link( $category->term_id ) ); ?>"><i class="fa fa-tag"></i><?php echo esc_attr( $category->name ) ?></a>
                      <?php   
                      $i++;     
                    }}         
                ?> 
                </li>
               <li class="pt-post-author"><i class="fa fa-user"></i><?php the_author(); ?></li>
            </ul>
         </div>
                 <?php if(!is_single()) { ?>
                         <h5 class="gt-blog-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                       <?php  } ?>

         <div class="gt-blog-info">
              <?php
                if(is_single())
                { 
                  the_content();
                } 
                else
                {
                  the_excerpt(); 
                   wp_link_pages( array(
                    'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'yog' ),
                    'after'       => '</div>',
                    'link_before' => '<span class="page-number">',
                    'link_after'  => '</span>',
                  ) );
                }
               
               ?>
         </div>
         <?php if(!is_single()) { ?>
         <div class="gt-btn-container">
            <div class="gt-button-block">
               <a href="<?php echo the_permalink(); ?>" class="gt-button"> <span><?php echo esc_html($btn_text); ?></span></a>
            </div>
         </div>
        <?php } ?>
      </div>
  </div>
   <?php 
      if(isset($theme_options['enable_comment']))
      {
        $options = $theme_options['enable_comment'];
        if($options == "yes")
        {
          if(is_single()){
            // If comments are open or we have at least one comment, load up the comment template.
            if ( comments_open() || get_comments_number() ) :
              comments_template();
            endif;
      
            
          }
        }
      }
      else {
        if(is_single()){
          // If comments are open or we have at least one comment, load up the comment template.
          if ( comments_open() || get_comments_number() ) :
            comments_template();
          endif;
      
          
        }
        
      }
      ?>
</article>
<!-- #post-## -->