<?php
/**
* Displays header widgets if assigned
*
* @package WordPress
* @subpackage yog
* @since 1.0
* @version 1.0
*/



?>

<?php
$theme_options = get_option('theme_options'); 

if(isset($theme_options['sticky_header_enable']) && $theme_options['sticky_header_enable'])
{
   $sticky = "gt-has-sticky";
}
else
{
	$sticky = '';
}

$row = "row no-gutters";
$soc_align = "";
$con_align = "";
$sticky = "";
$sidebar_logo = "";
$hide_top = "";
if(isset($theme_options['sticky_header_enable']) && $theme_options['sticky_header_enable'])
{
   $sticky = "gt-has-sticky";
}
if(isset($theme_options['pt_top_header_layout']))
{
   if($theme_options['pt_top_header_layout'] == 'social-right')
   {
      $row = "row no-gutters flex-row-reverse";
      $soc_align = "text-right";
      $con_align = "";
   }
   if($theme_options['pt_top_header_layout'] == 'social-left')
   {
      $row = "row no-gutters";
      $soc_align = "";
      $con_align = "text-right";
   }

}
if(isset($theme_options['sidebar_logo']) && !empty($theme_options['sidebar_logo']['url']))
{
	$sidebar_logo = $theme_options['sidebar_logo']['url'];		
}
// print_r($theme_options['top_header_enable']);
if ($theme_options['top_header_enable'] == 'no') 
{
	$hide_top = "gt-topbar-hide";
}

?>
<div class="gt-background-overlay"></div>
<div class="gt-sidebar">
	<div class="gt-close-btn">
		<a class="gt-close" href="javascript:void(0)">
			<i class="ion-close-round"></i>
		</a>
	</div>
	<div class="gt-sidebar-block mCustomScrollbar">
		<div class="gt-sidebar-header">
		<img src="<?php echo esc_url($sidebar_logo); ?>" class="gt-sidebar-logo" alt="<?php esc_attr_e('yog-sidebar-logo','yog'); ?>">
		
			<?php
			if(isset($theme_options['sidebar_desc']) && !empty($theme_options['sidebar_desc']))
			{
			?>
			<p><?php echo esc_html($theme_options['sidebar_desc']); ?></p>
			<?php 
			} 
			?>		
	</div>
	<div class="gt-sidebar-post">
			
			<?php
			$args = array( 'post_type' => 'post', 'posts_per_page' => '4', );
			$loop = new WP_Query( $args );
			while ( $loop->have_posts() ) 
			{ 
				$loop->the_post();
				$image_url = wp_get_attachment_url( get_post_thumbnail_id($loop->ID) );
				?>
				<div class="gt-foote-recent-post">
					<div class="gt-foote-recent-post-media">
						<a href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
							<img src="<?php echo esc_url($image_url); ?> " alt="<?php esc_attr_e('yog-sidebar-logo','yog'); ?>"></a>
						</div>
						<div class="gt-foote-recent-post-info">
							<?php
							$archive_year  = get_the_time( 'Y' ); 
							$archive_month = get_the_time( 'm' ); 
							$archive_day   = get_the_time( 'd' ); 
							?>
							<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>" class="gt-post-date"><?php echo esc_html( get_the_date('F',get_the_ID()));?> <span><?php echo esc_html( get_the_date('d',get_the_ID())); ?></span>, <?php echo esc_html( get_the_date('Y',get_the_ID()));?> </a>
							<h6><a href="<?php esc_html( get_the_title() ); ?>"><?php the_title();?></a></h6>
						</div>
					</div>					
					<?php
				}
				wp_reset_query();
				?>
			</div>
	<div class="gt-sidebar-contact">
		<h5>Contacts</h5>
		<ul class="gt-sidebar-contact">
				<?php
				if(!empty($theme_options['yog_address']))
				{ 
				?>						
				<li>
					<i class="fa fa-map-marker"></i>
					<span>
						<?php echo esc_html($theme_options['yog_address']); ?>
					</span>
				</li>
				<?php } ?>
				
				
				<?php
				if(!empty($theme_options['yog_phone']))
				{ 
				?>
				<li>
				
				<a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_phone']); ?>"><i class="fa fa-phone"></i>
					<span><?php echo esc_html($theme_options['yog_phone']); ?></span>
				</a>
				</li>
				<?php } ?>
				
				
				<?php
				if(!empty($theme_options['yog_email']))
				{ 
				?>
				<li>
				
				<a href="mailto:<?php echo esc_html($theme_options['yog_email']); ?>"><i class="fa fa-envelope"></i><span><?php echo esc_html($theme_options['yog_email']); ?></span></a>
				</li>
				<?php } ?>
		</ul>
	</div>
	 <div class="gt-sidebar-social">
       	<ul>
	         <?php 
	         foreach ($theme_options['yog_social'] as $key => $value) {
	         if(!empty($value))
	         {
	         ?>
	         <li><a href="<?php echo esc_url($value); ?>"><i class="fab <?php echo esc_attr($key); ?>"></i></a></li>

	         <?php } } ?>
      	</ul>
      </div>
	</div>
	
</div>
      

<header id="gt-header" class="gt-header-style-2 <?php echo esc_attr($sticky); ?> <?php echo esc_attr($hide_top); ?>">

	<?php 
	if(class_exists('ReduxFramework'))
	{
	 //get_template_part( 'template-parts/header/header-top', 'two' );
	}
	?>
   <div class="gt-header-diff-block">
   
   <div class="row no-gutters">
      <div class="col-lg-2 col-md-4">
         <a class="navbar-brand" href="<?php  echo esc_url( home_url( '/' ) ); ?>">
            <?php yog_display_logo(); ?>
         </a>
      </div>
      <div class="col-lg-10 col-md-8">
         <div class="gt-top-header">            
               <div class="<?php echo esc_attr($row); ?>">   
               <div class="col-lg-3 col-xl-4">
                     <div class="gt-header-social <?php echo esc_attr($soc_align); ?>">
                        <ul>
                     <?php 
                     foreach ($theme_options['yog_social'] as $key => $value) {
                     if(!empty($value))
                     {
                     ?>
                     <li><a href="<?php echo esc_url($value); ?>"><i class="fab <?php echo esc_attr($key); ?>"></i></a></li>

                  <?php } } ?>
                  </ul>
                     </div>
                  </div>              
                  <div class="col-lg-9 col-xl-8">
                     <div class="gt-header-contact <?php echo esc_attr($con_align); ?>">
	                        <ul>
	                     <?php
	                  if(!empty($theme_options['yog_phone']))
	                  { 
	                  ?>
	                  <li>
	                  
	                  <a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_phone']); ?>"><i class="fas fa-phone"></i>
	                     <span><?php echo esc_html($theme_options['yog_phone']); ?></span>
	                  </a>
	                  </li>
	                  <?php } ?>
	                     <?php
	                  if(!empty($theme_options['yog_email']))
	                  { 
	                  ?>
	                  <li>
	                  
	                  <a href="mailto:<?php echo esc_html($theme_options['yog_email']); ?>"><i class="fas fa-envelope"></i><span><?php echo esc_html($theme_options['yog_email']); ?></span></a>
	                  </li>
	                  <?php } ?>
                     
                     <?php 
                     if(!empty($theme_options['yog_time']))
                     {
                     ?>
                     <li>
                        <i class="far fa-clock"></i>
                        <a href="#"><?php echo esc_html($theme_options['yog_time']); ?></a>
                     </li>
                  <?php } ?>
	                  
	                  </ul>
                        
                     </div>
                  </div>
                   
               </div>
            
         </div>
         <div class="gt-bottom-header">
            
               <div class="row no-gutters">
                  
                  <div class="col-lg-12">
                     <nav class="navbar navbar-expand-lg navbar-light">
                        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                        <i class="fas fa-bars"></i>
                        </button>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                           <?php if ( has_nav_menu( 'primary' ) ) : ?>
                           <?php wp_nav_menu( array(
                              'theme_location' => 'primary',
                                 			'menu_class'  => 'navbar-nav ml-auto',
                                 			'menu_id'     => 'gt-main-menu',
                              'container_id' => 'gt-menu-contain',
                                 			'container_class' => 'gt-menu-contain',
                              		) ); ?>
                           <?php endif; ?>
                        </div>
                        <div class="gt-header-info-box">
                           <div class="gt-menu-search-block">
                              <a href="javascript:void(0)" id="gt-seacrh-btn"><i class="fa fa-search"></i></a>
                              <div class="gt-search-form">
                                 <?php get_search_form(); ?>
                              </div>
                           </div>
                           <?php 
						if ( class_exists( 'WooCommerce' ) ) 
						{
							?>
							<div class="gt-shop-btn">
								<div class="gt-cart"><?php echo do_shortcode( '[yog-mini-cart]' ); ?></div>
							</div>
						<?php } ?>
                           
                           <div class="gt-toggle-btn">
                             <a href="javascript:void(0)" class='menu-toggle'>Menu</a>
                           </div>
                        </div>
                     </nav>
                  </div>
               </div>
         </div>
      </div>
   </div>
</div>
</header>
