<?php
/**
* Displays header widgets if assigned
*
* @package WordPress
* @subpackage yog
* @since 1.0
* @version 1.0
*/


$theme_options = get_option('theme_options'); 
if(isset($theme_options['sticky_header_enable']) && $theme_options['sticky_header_enable'])
{
   $sticky = "gt-has-sticky";
}
else
{
	$sticky = '';
}
?>

<header id="gt-header" class="gt-header-style-1 <?php echo esc_attr($sticky); ?>">	
	<?php 
	// if(class_exists('ReduxFramework'))
	// {
  //get_template_part( 'template-parts/header/header-top', 'two' );
	 
	// }
	?>

	<div class="gt-bottom-header">
		<div class="container-fluid">
			<div class="row no-gutters">
				<div class="col-lg-12">
				<nav class="navbar navbar-expand-lg navbar-light">
	              <a class="navbar-brand" href="<?php  echo esc_url( home_url( '/' ) ); ?>">
	             	<?php yog_display_logo(); ?>	                
	              </a>
	             
	              <div class="collapse navbar-collapse" id="navbarSupportedContent">
	                <?php if ( has_nav_menu( 'primary' ) ) : ?>
					<?php wp_nav_menu( array(
						'theme_location' => 'primary',
	        			'menu_class'  => 'navbar-nav ml-auto',
	        			'menu_id'     => 'gt-main-menu',
						'container_id' => 'gt-menu-contain',
	        			'container_class' => 'gt-menu-contain',
								) ); ?>
					<?php endif; ?>
	              </div>
	               <div class="gt-header-info-box">
	               	<?php 
						if ( class_exists( 'WooCommerce' ) ) 
						{
							?>
							<div class="gt-shop-btn">
								<div class="gt-cart"><?php echo do_shortcode( '[yog-mini-cart]' ); ?></div>
							</div>
						<?php } ?>
	              	<div class="gt-header-call">
	              		 <?php
	              		 // print_r($theme_options['yog_phone']);
	                  if(!empty($theme_options['yog_phone']))
	                  { 
	                  ?>
		              	<a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_phone']); ?>">
		              		<i class="ion-ios-telephone"></i>
		              		<div class="gt-call-info">
			              		<h5><?php echo esc_html($theme_options['yog_phone']); ?></h5>
			              		<?php
			              		if(isset($theme_options['header_contact_text']) && !empty($theme_options['header_contact_text']))
			              		{
			              			$text = $theme_options['header_contact_text'];
			              		} 
			              		else
			              		{
			              			$text = 'Make a call';
			              		}
			              		?>
			              		<span><?php echo esc_html($text); ?></span>
		              		</div>
		              	</a>
		              <?php } ?>
	              	</div>

	              	<div class="gt-btn-container">
	              		<?php
	              		if(isset($theme_options['action_btn_url']) && !empty($theme_options['action_btn_url']))
	              		{
	              			$url = $theme_options['action_btn_url'];
	              		} 
	              		else
	              		{
	              			$url = "#";
	              		}
	              		?>
	              		<div class="gt-button-block">
	              		<a href="<?php echo esc_url($url); ?>" class="gt-button">
		                	
			                  <?php
			                  	if(isset($theme_options['action_btn_text']) && !empty($theme_options['action_btn_text']))
			                  	{
			                  		$text = $theme_options['action_btn_text'];
			                  	} 
			                  	else
			                  	{
			                  		$text = 'Get Quote';
			                  	}
			                  ?>
			                  <span  class="gt-button-text"><?php echo esc_html($text); ?></span>
		                  
              			</a>
              			</div>
	              	</div>	              	
	              </div>
	               <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
	              <i class="fas fa-bars"></i>
	              </button>								
	             
	            </nav>

				</div>
			</div>
		</div>
	</div>
	
</header>