<?php
/**
* Displays header widgets if assigned
*
* @package WordPress
* @subpackage yog
* @since 1.0
* @version 1.0
*/
$sticky = 'gt-has-sticky';
$theme_options = get_option('theme_options'); 
if(isset($theme_options['sticky_header_enable']))
{
  if(!$theme_options['sticky_header_enable'])
  {
  	$sticky = '';	
  }
   
}
$sidebar_logo = '';

if(isset($theme_options['sidebar_logo']) && !empty($theme_options['sidebar_logo']['url']))
{
	$sidebar_logo = $theme_options['sidebar_logo']['url'];		
}
else
{
	    $sidebar_logo = YOG_URL.'/assets/img/logo.png';
}
?>
<div class="gt-background-overlay"></div>
<div class="gt-sidebar">
	<div class="gt-close-btn">
		<a class="gt-close" href="javascript:void(0)">
			<i class="ion-close-round"></i>
		</a>
	</div>
	<div class="gt-sidebar-block mCustomScrollbar">
		<div class="gt-sidebar-header">
			<?php
			if(!empty($sidebar_logo))
			{ 
				?>
					              <a class="navbar-brand" href="<?php  echo esc_url( home_url( '/' ) ); ?>">

				<img src="<?php echo esc_url($sidebar_logo); ?>" class="gt-sidebar-logo" alt="<?php esc_attr_e('yog-sidebar-logo','yog'); ?>">
			</a>
			<?php } ?>
			<?php
			if(isset($theme_options['sidebar_desc']) && !empty($theme_options['sidebar_desc']))
			{
				?>
				<p><?php echo esc_html($theme_options['sidebar_desc']); ?></p>
				<?php 
			} 
			?>		
		</div>
		<div class="gt-sidebars">
			<?php dynamic_sidebar('pt_footer_6');	
			?>			
		</div>
		
		
		</div>
	</div>
<header id="gt-header" class="gt-header-default">
	<?php 
	if(class_exists('ReduxFramework'))
	{

		if($theme_options['top_header_enable'] == 'yes')
		{
		 	//get_template_part( 'template-parts/header/header-top', 'two' );
		 	get_template_part( 'template-parts/header/header', 'top' );
		}
	}
	?>
	<div class="gt-bottom-header <?php echo esc_attr($sticky); ?>">
		<div class="container">
			<div class="row">
				<div class="col-lg-12">
					<nav class="navbar navbar-expand-lg navbar-light">
	              <a class="navbar-brand" href="<?php  echo esc_url( home_url( '/' ) ); ?>">
	               <?php yog_display_logo(); ?> 
	                
	              </a>
	              
	              <div class="collapse navbar-collapse" id="navbarSupportedContent">
	                <?php if ( has_nav_menu( 'primary' ) ) : ?>
					<?php wp_nav_menu( array(
						'theme_location' => 'primary',
	        			'menu_class'  => 'navbar-nav ml-auto',
	        			'menu_id'     => 'gt-main-menu',
						'container_id' => 'gt-menu-contain',
	        			'container_class' => 'gt-menu-contain',
								) ); ?>
					<?php endif; ?>
	              </div>
	              <?php 
	              if(class_exists('ReduxFramework'))
				  {
				  ?>
	              <div class="gt-menu-search-block">
	              	<a href="javascript:void(0)" id="gt-seacrh-btn"><i class="fa fa-search"></i></a>
	              	<div class="gt-search-form">
	              		<?php get_search_form(); ?>
	              	</div>	              	
	              </div>
	              <?php 
						if ( class_exists( 'WooCommerce' ) ) 
						{
							?>
							<div class="gt-shop-btn">
								<div class="gt-cart"><?php echo do_shortcode( '[yog-mini-cart]' ); ?></div>
							</div>
						<?php } ?>
	             <?php
	             if ($theme_options['header_action_enable'] == 'yes') {
	             	
	            
	              ?>
	              <div class="gt-btn-container">
	              		<?php
	              		if(isset($theme_options['action_btn_url']) && !empty($theme_options['action_btn_url']))
	              		{
	              			$url = $theme_options['action_btn_url'];
	              		} 
	              		else
	              		{
	              			$url = "#";
	              		}
	              		?>
	              		<a href="<?php echo esc_url($url); ?>" class="gt-button">
		                	<div class="gt-button-block">
			                  <span class="gt-button-line-left"></span>
			                  <?php
			                  	if(isset($theme_options['action_btn_text']) && !empty($theme_options['action_btn_text']))
			                  	{
			                  		$text = $theme_options['action_btn_text'];
			                  	} 
			                  	else
			                  	{
			                  		$text = 'Get Quote';
			                  	}
			                  ?>
			                  <span  class="gt-button-text"><?php echo esc_html($text); ?></span>
		                </div>  
              			</a>
	              	</div>
	              <?php } } ?>	
	              <?php
								if(class_exists('ReduxFramework'))
								{ 
									?>
									<div class="gt-toggle-btn">
										<a href="javascript:void(0)" class='menu-toggle'><i class="ion-navicon"></i></a>
									</div>
								<?php } ?>
	              <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
	              <i class="fas fa-bars"></i>
	              </button>								
	             
	            </nav>

				</div>
			</div>
		</div>
	</div>
</header>