<?php 
if(class_exists('ReduxFramework'))
{
	$theme_options = get_option('theme_options'); 
	if(isset($theme_options['subscribe_img']) && !empty($theme_options['subscribe_img']['url']))
	{
		$img = $theme_options['subscribe_img']['url'];
	}
	else
	{
		$img = '';
	}

?>
<div class="gt-subscribe align-items-center">
	<div class="container">
		<div class="row">
			<div class="col-lg-6">
				<div class="gt-subscribe-block">
					<?php
					if(!empty($img))
					{ 
					?>
					<img src="<?php echo esc_url($img); ?>" class="gt-subscribe-img" alt="<?php esc_attr_e( 'yog-subscribe-image', 'yog' ); ?>">
					<?php } ?>
					<div class="gt-subscribe-details">
						<h6><?php if(isset($theme_options['yog_subscribe_title'])) { echo esc_html($theme_options['yog_subscribe_title']); } ?></h6>
						<span>
							<?php
							if(isset($theme_options['yog_copyright_description'])) 
							{

								echo esc_html($theme_options['yog_copyright_description']);
							}
							?>
								
							</span>
					</div>
				</div>
			</div>
			<div class="col-lg-6 align-self-center">
				<div class="gt-subscribe-from">
					<?php
						if(isset($theme_options['yog_subscribe_shortcode']) && !empty($theme_options['yog_subscribe_shortcode']))
						{
							echo do_shortcode($theme_options['yog_subscribe_shortcode']); 
						} 
						
					?>
				</div>
			</div>
		</div>
	</div>
</div>
<?php } ?>