<?php 
$course = learn_press_get_course();
$theme_options = get_option('theme_options');
$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
$price = $course->get_price_html();

?>
<div class="gt-service-box gt-service-box-style-4">
	<div class="gt-courses-img">
		<a href="<?php the_permalink(); ?>" class="course-permalink">
			<?php
			
			echo $course->get_image( 'course_thumbnail' );
			?>
		</a>
	</div>
	<div class="gt-service-info">
		<div class="gt-service-contain">
			<div class="gt-sub-title">
				<div class="course-categories">
					<?php 
                $terms = get_the_terms( get_the_ID(), 'course_category' );

                if ( $terms && ! is_wp_error( $terms ) ) { 

                $draught_links = array();

                foreach ( $terms as $term ) {
                $draught_links[] = $term->name;
                }
                ?>
                <a href="<?php the_permalink(); ?>"><?php echo esc_html($term->name); ?></a>
                <?php
                }
                ?>
            	</div>
			</div>
			<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
			
		</div>
		
		<div class="gt-service-meta">
			<div class="gt-service-star">
				<?php if (class_exists('LP_Addon_Course_Review')) {
					
					$course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
					learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate_res['rated'] ) );
				}
				?>
			</div>
			<div class="gt-service-price">
				<div class="course-price">
					<?php if ( $course->has_sale_price() ) : ?>
						<span class="origin-price"> <?php echo $course->get_origin_price_html(); ?></span>
					<?php endif; ?>
					<span class="price"><?php echo $price; ?></span>
				</div>
			</div>
		</div>
	</div>
</div>
