<?php 
$course = learn_press_get_course();
$theme_options = get_option('theme_options');
$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
?>

<div class="gt-service-box gt-service-box-style-3">
	<div class="single-courses-box">
		<div class="gt-courses-img">
			<a href="<?php the_permalink(); ?>" class="course-permalink">
				<?php echo $course->get_image( 'course_thumbnail' ); ?>
			</a>
		</div>
		<div class="gt-service-info">
			<div class="gt-service-media"><?php learn_press_courses_loop_item_price(); ?></div>
			<div class="course-categories">
					<?php 
                $terms = get_the_terms( get_the_ID(), 'course_category' );

                if ( $terms && ! is_wp_error( $terms ) ) { 

                $draught_links = array();

                foreach ( $terms as $term ) {
                $draught_links[] = $term->name;
                }
                ?>
                <a href="<?php the_permalink(); ?>"><?php echo esc_html($term->name); ?></a>
                <?php
                }
                ?>
            	</div>
			<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
			<p><?php the_excerpt(); ?></p>
			<div class="gt-service-meta">
				<?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
				<ul>
					<li class="gt-post-meta"><i class="fa fa-calendar"></i>
						<?php echo wp_kses_post( $course->get_curriculum_items( 'lp_lesson' ) ? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0 ); ?> <?php echo esc_html( $lessons_title ); ?>
					</li>
					<li class="gt-post-author"><i class="fa fa-users"></i>
						<?php echo esc_html( $user_count ); ?> <?php echo esc_html( $students_title ); ?>
					</li>
				</ul>
			</div>
		</div>
	</div>
</div>