<?php 
  $theme_options = get_option('theme_options');

  $btn_text = 'Read More';
  if(isset($theme_options['blog_btn_text']) && !empty($theme_options['blog_btn_text']))
  {
    $btn_text = $theme_options['blog_btn_text'];
  }
$course = learn_press_get_course();
$theme_options = get_option('theme_options');
$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
?>

<div class="gt-service-box gt-service-box-style-2">
	<div class="gt-service-img">
		<a href="<?php the_permalink(); ?>" class="course-permalink">
			<?php
			if ( has_post_thumbnail() )
			{
							// the_post_thumbnail();
				echo $course->get_image( 'course_thumbnail' );
			} ?>
			
		</a>
	</div>
	<div class="gt-service-info">
		<div class="gt-service-star">
			<?php if (class_exists('LP_Addon_Course_Review')) {
				
				$course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
				learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate_res['rated'] ) );
			}
			?>
		</div>
		<div class="gt-service-contain">
			<div class="course-categories">
				<?php 
                $terms = get_the_terms( get_the_ID(), 'course_category' );

                if ( $terms && ! is_wp_error( $terms ) ) { 

                $draught_links = array();

                foreach ( $terms as $term ) {
                $draught_links[] = $term->name;
                }
                ?>
                <a href="<?php the_permalink(); ?>"><?php echo esc_html($term->name); ?></a>
                <?php
                }
                ?>
            	</div>
			<h4 class="gt-service-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?> </a></h4>

			<div class="gt-service-price"><?php learn_press_courses_loop_item_price(); ?></div>
		</div>
		<div class="gt-service-meta">
			<ul>
				<li class="gt-post-meta"><i class="fa fa-calendar"></i>
					<?php echo wp_kses_post( $course->get_curriculum_items( 'lp_lesson' ) ? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0 ); ?> <?php echo esc_html( $lessons_title ); ?>
				</li>
				<li class="gt-post-author"><i class="fa fa-users"></i><?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
				<?php echo esc_html( $user_count ); ?> <?php echo esc_html( $students_title ); ?>
			</li>
			<li class="gt-post-author"><i class="fa fa-user"></i><?php echo $course->get_instructor_html(); ?></li>
		</ul>
	</div>
	<!-- <div class="gt-btn-container">
            <div class="gt-button-block">
               <a href="<?php //echo the_permalink(); ?>" class="gt-button"> <span><?php// echo esc_html($btn_text); ?></span></a>
            </div>
         </div> -->
</div>
</div>