<?php 
$course = learn_press_get_course();
$theme_options = get_option('theme_options');
$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
?>

<div class="gt-service-box gt-service-box-style-1">
	<div class="gt-service-img">
		<a href="<?php the_permalink(); ?>" class="course-permalink">
			<?php
			if ( has_post_thumbnail() )
			{
							// the_post_thumbnail();
				echo $course->get_image( 'course_thumbnail' );
			} ?>
			
		</a>
		<div class="gt-service-hover-contain">
		<div class="gt-service-list">
			<div class="gt-post-list">
				<div class="gt-post-list-icon">
					<i class="fa fa-book"></i>
				</div>
				<div class="gt-contain-list">
					<?php echo wp_kses_post( $course->get_curriculum_items( 'lp_lesson' ) ? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0 ); ?> <?php echo esc_html( $lessons_title ); ?>
				</div>
			</div>
			<div class="gt-post-list">
				<div class="gt-post-list-icon">
					<i class="fa fa-user"></i>
				</div>
				<div class="gt-contain-list">
					<?php $user_count = $course->get_users_enrolled() ? $course->get_users_enrolled() : 0; ?>
					<?php echo esc_html( $user_count ); ?> <?php echo esc_html( $students_title ); ?>
				</div>
			</div>
			<div class="gt-post-list">
				<div class="gt-post-list-icon">
					<i class="fa fa-tag"></i>
				</div>
				<div class="gt-contain-list">
					<?php
					$categories = get_the_term_list( '', 'course_category' );
					
					if ( ! empty( $categories ) ) : ?>
						<div class="course-categories">
							
							<a href="<?php the_permalink(); ?>"><?php echo $categories; ?></a>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</div>
	</div>
	</div>
	
	<div class="gt-service-info">
		<div class="gt-service-media">
			<?php echo $course->get_instructor()->get_profile_picture(); ?>
		</div>
		<div class="gt-sub-title">
			<div class="course-categories">
				<?php 
                $terms = get_the_terms( get_the_ID(), 'course_category' );

                if ( $terms && ! is_wp_error( $terms ) ) { 

                $draught_links = array();

                foreach ( $terms as $term ) {
                $draught_links[] = $term->name;
                }
                ?>
                <a href="<?php the_permalink(); ?>"><?php echo esc_html($term->name); ?></a>
                <?php
                }
                ?>
            	</div>
		</div>
		<h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
		<div class="gt-service-meta">
			<div class="gt-service-price"><?php learn_press_courses_loop_item_price(); ?></div>
			<div class="gt-service-star">
				<?php if (class_exists('LP_Addon_Course_Review')) {
					
					$course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
					learn_press_course_review_template( 'rating-stars.php', array( 'rated' => $course_rate_res['rated'] ) );
				}
				?>
			</div>
		</div>
	</div>
</div>
