<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package WordPress
 * @subpackage yog
 * @since 1.0
 * @version 1.0
 */
get_header(); 
$theme_options = get_option('theme_options'); 
$row = 'row';
$blogcol = 'col-xl-12 col-lg-12 col-md-12';
$sidecol = 'col-xl-4 col-lg-4 col-md-12';
$sidebar = true;
if(is_active_sidebar('sidebar-1'))
{
	$sidebar = true;
	$blogcol = 'col-lg-8 col-xl-8 col-md-12';
}
else
{
	$sidebar = false;
	$blogcol = 'col-lg-12';
}
if(isset($pt_theme_opt['single_blog_layout'])){
	if($theme_options['single_blog_layout']  === 'no_sidebar'){
		$sidebar = false;
		$blogcol = 'col-xl-12 col-lg-12 col-md-12';
	}
	else if($theme_options['single_blog_layout']  === 'right_sidebar'){
		if(is_active_sidebar('sidebar-1'))
		{
			$sidebar = true;
			$blogcol = 'col-xl-8 col-lg-8 col-md-12';
		}
		
		
		$row = 'row';
	}
	else if($theme_options['single_blog_layout']  === 'left_sidebar'){
		if(is_active_sidebar('sidebar-1'))
		{
			$sidebar = true;
			$blogcol = 'col-xl-8 col-lg-8 col-md-12';
		}	
		$row = 'row flex-row-reverse';
	}
	else
	{
		if(is_active_sidebar('sidebar-1'))
		{
			$sidebar = true;
			$blogcol = 'col-xl-8 col-lg-8 col-md-12';
		}
		
	}
}
?>
<div class="Gentechtree-contain-area">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="container">
				<div class="<?php echo esc_attr($row); ?>">
					<div class="<?php echo esc_attr($blogcol); ?>">					
					<?php
					while ( have_posts() ) : the_post(); 
						get_template_part( 'template-parts/post/content', get_post_format() );
					endwhile; // End of the loop. ?>
					</div>
					<?php if ( $sidebar) { ?>		
					<div class="<?php echo esc_attr($sidecol); ?>">
						<?php get_sidebar(); ?>
					</div>
					<?php } ?>
				</div>
			</div><!-- #primary -->
		</main><!-- #main -->
	</div><!-- .container -->
</div>
<?php get_footer(); ?>