<?php
/**
* Template for displaying content of course without header and footer
*
* @author  ThimPress
* @package LearnPress/Templates
* @version 4.0.0
*/

defined( 'ABSPATH' ) || exit();

/**
* If course has set password
*/
if ( post_password_required() ) {
    echo get_the_password_form();
    return;
}

/**
* LP Hook
*/
do_action( 'learn-press/before-single-course' );

?>
<div id="learn-press-course" class="course-summary">
    <?php
/**
* @since 3.0.0
*
* @called single-course/content.php
* @called single-course/sidebar.php
*/
do_action( 'learn-press/single-course-summary' );
?>
</div>
<!-- Start Related Area -->
<?php
$theme_options = get_option('theme_options');

$slider_style = $theme_options['course_slider_style'];

$related_courses_title = !empty($theme_options['related_courses_title']) ? $theme_options['related_courses_title'] : 'More Courses You Might Like';

$related_courses_subtitle = !empty($theme_options['related_courses_subtitle']) ? $theme_options['related_courses_subtitle'] : 'Our Services';

$lessons_title      = !empty($theme_options['lessons_title']) ? $theme_options['lessons_title'] : 'Lessons';
$students_title     = !empty($theme_options['students_title']) ? $theme_options['students_title'] : 'Students';
$related_post_count = !empty($theme_options['related_post_count']) ? $theme_options['related_post_count'] : '3';
$is_related_courses = !empty($theme_options['is_related_courses']) ? $theme_options['is_related_courses'] : '';
$course_terms = get_the_terms( get_the_ID(), 'course_category'  );
if( $is_related_courses == '1' ){
    if( $course_terms ) {
        $course_term_names[] = 0;
        foreach( $course_terms as $course_term ) {  
            $course_term_names[] = $course_term->name;            
        }                        
// set up the query arguments
        $args = array (
            'post_type' => 'lp_course',
            'posts_per_page' => $related_post_count,
            'tax_query' => array(
                array(
                    'taxonomy' => 'course_category',
                    'field'    => 'slug',
                    'terms'    => $course_term_names,
                ),
            ),
        );
        $query = new WP_Query( $args ); 
        if( $query->have_posts() ) { ?>

            <section class="slider-course-area">
                <div class="container">
                    <?php if( $related_courses_title != '' ): ?>
                        <div class="gt-section-title-box text-center">
                            <span class="gt-section-sub-title">// <?php echo esc_html($related_courses_subtitle); ?></span>
                            <h2><?php echo esc_html($related_courses_title); ?></h2>
                        </div>
                    <?php endif; ?>
                    <div class="owl-carousel owl-loaded owl-drag" data-dots="false" data-nav="false" data-desk_num="3" data-lap_num="2" data-tab_num="1" data-mob_num="1" data-mob_sm="1" data-autoplay="true" data-loop="true" data-margin="30">        					
                        <?php 
                        while ( $query->have_posts() ) : $query->the_post(); $course  = LP()->global['course'];  ?>

                            <div class="item">
                                <?php get_template_part( 'template-parts/course/style',  $slider_style); ?>

                            </div>
                        <?php endwhile; ?>  
                        <?php wp_reset_postdata(); ?>
                    </div>
                </div>
            </section>
            <?php
        }
    }
} 

/**
* LP Hook
*/
do_action( 'learn-press/after-single-course' );
