<?php
/**
 * Template for displaying content of archive courses page.
 *
 * @author  ThimPress
 * @package LearnPress/Templates
 * @version 4.0.0
 */

defined( 'ABSPATH' ) || exit;

/**
 * @since 4.0.0
 *
 * @see LP_Template_General::template_header()
 */
do_action( 'learn-press/template-header' );

/**
 * LP Hook
 */
do_action( 'learn-press/before-main-content' );

$page_title = learn_press_page_title( false );
$theme_options = get_option('theme_options');
?>

<div class="lp-content-area">
	

	<?php
	/**
	 * LP Hook
	 */

	$course_style = '';
	if(isset($_REQUEST['course_style']) && !empty($_REQUEST['course_style']))
	{
		$course_style = $_REQUEST['course_style'];
	}
	else if(isset($theme_options['course_style']) && $theme_options['course_style'] != 'inherit')
	{
		$course_style = $theme_options['course_style'];
	}
	$block_data = array(
		'box_style' => $course_style
	);
	if(!empty($course_style))
	{
		echo '<div class="row">';
		while ( have_posts() ) :
			the_post();
			echo '<div class="col-xl-4 col-md-6">';
				get_template_part( 'template-parts/course/style',  $course_style);
			echo '</div>';
		endwhile;
		echo '</div>'; //End RoW Div
	}
	else
	{
	 if ( $page_title ) : ?>
		<header class="learn-press-courses-header">
			<h1><?php echo $page_title; ?></h1>
		</header>
	<?php endif; 
		do_action( 'learn-press/before-courses-loop' );	
		LP()->template( 'course' )->begin_courses_loop();
		while ( have_posts() ) :
		the_post();
			learn_press_get_template_part( 'content', 'course' );	
		endwhile;
		LP()->template( 'course' )->end_courses_loop();
		
	}
	
		do_action( 'learn-press/after-courses-loop' );
		// echo '<div class="row">';
		// yog_pagination();
		// echo '</div>'; //End RoW Div
		do_action( 'learn-press/after-main-content' );
		wp_reset_postdata();


	/**
	 * LP Hook
	 */
	

	/**
	 * LP Hook
	 *
	 * @since 4.0.0
	 */
	do_action( 'learn-press/sidebar' );
	?>
</div>

<?php
/**
 * @since 4.0.0
 *
 * @see   LP_Template_General::template_footer()
 */
do_action( 'learn-press/template-footer' );
