<?php
 
/**
 * Additional features to allow styling of the templates
 *
 * @package WordPress
 * @subpackage yog
 * @since 1.0
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function yog_body_classes( $classes ) {
	// Add class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Add class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Add class if we're viewing the Customizer for easier styling of theme options.
	if ( is_customize_preview() ) {
		$classes[] = 'yog-customizer';
	}

	// Add class on front page.
	if ( is_front_page() && 'posts' !== get_option( 'show_on_front' ) ) {
		$classes[] = 'yog-front-page';
	}

	// Add a class if there is a custom header.
	if ( has_header_image() ) {
		$classes[] = 'has-header-image';
	}

	// Add class if sidebar is used.
	if ( is_active_sidebar( 'sidebar-1' ) && ! is_page() ) {
		$classes[] = 'has-sidebar';
	}

	// Add class for one or two column page layouts.
	if ( is_page() || is_archive() ) {
		if ( 'one-column' === get_theme_mod( 'page_layout' ) ) {
			$classes[] = 'page-one-column';
		} else {
			$classes[] = 'page-two-column';
		}
	}

	// Add class if the site title and tagline is hidden.
	if ( 'blank' === get_header_textcolor() ) {
		$classes[] = 'title-tagline-hidden';
	}

	// Get the colorscheme or the default if there isn't one.
	$colors = yog_sanitize_colorscheme( get_theme_mod( 'colorscheme', 'light' ) );
	$classes[] = 'colors-' . $colors;


	return $classes;
}
add_filter( 'body_class', 'yog_body_classes' );

/**
 * Count our number of active panels.
 *
 * Primarily used to see if we have any panels active, duh.
 */
function yog_panel_count() {

	$panel_count = 0;

	/**
	 * Filter number of front page sections in yog.
	 *
	 * @since yog 1.0
	 *
	 * @param int $num_sections Number of front page sections.
	 */
	$num_sections = apply_filters( 'yog_front_page_sections', 4 );

	// Create a setting and control for each of the sections available in the theme.
	for ( $i = 1; $i < ( 1 + $num_sections ); $i++ ) {
		if ( get_theme_mod( 'panel_' . $i ) ) {
			$panel_count++;
		}
	}

	return $panel_count;
}

/**
 * Checks to see if we're on the homepage or not.
 */
function yog_is_frontpage() {
	return ( is_front_page() && ! is_home() );
}
// add_filter( 'walker_nav_menu_start_el', 'yog_add_arrow',10,4);
// function yog_add_arrow( $output, $item, $depth, $args ){

// //Only add class to 'top level' items on the 'primary' menu.
// if('primary' == $args->theme_location && $depth === 0 ){
//     if (in_array("menu-item-has-children", $item->classes)) {
//         $output .='<i class="ion-chevron-down"></i>';
//     }
// }
//     return $output;
// }
function yog_customize_comment_field($fields)
{
    $commenter = wp_get_current_commenter();
    
    $req      = get_option('require_name_email');
    $aria_req = ($req ? " aria-required='true'" : '');
    
    $comment_field = $fields['comment'];
    unset($fields['comment']);
    unset($fields['cookies']);
    unset($fields['author']);
    unset($fields['url']);
    unset($fields['email']);
    
    $fields['author'] = '<p class="comment-form-author"><input id="author" name="author" type="text" value="' . esc_attr($commenter['comment_author']) . '" size="30"' . $aria_req . ' placeholder="' . esc_attr(__('* Enter Name', 'yog')) . '" required/></p>';
    
    $fields['email'] = '<p class="comment-form-email"><input id="email" name="email" type="email" value="' . esc_attr($commenter['comment_author_email']) . '" size="30"' . $aria_req . ' placeholder="' . esc_attr(__('* Enter Email', 'yog')) . '" required/></p>';
    
    $fields['url'] = '<p class="comment-form-url"><input id="url" name="url" type="url" value="" size="30" placeholder="' . esc_attr(__('Enter Url', 'yog')) . '"></p>';
    
    $fields['comment'] = $comment_field;
    
    
    
    return $fields;
}

add_filter('comment_form_fields', 'yog_customize_comment_field');

function menu_set_dropdown( $sorted_menu_items, $args ) {
  $last_top = 0;
  foreach ( $sorted_menu_items as $key => $obj ) {
      // it is a top lv item?
      if ( 0 == $obj->menu_item_parent ) {
          // set the key of the parent
          $last_top = $key;
      } else {
          $sorted_menu_items[$last_top]->classes['dropdown'] = 'dropdown';
      }
  }
  return $sorted_menu_items;
}
add_filter( 'wp_nav_menu_objects', 'menu_set_dropdown', 10, 2 );
function yog_add_sub_toggles_to_main_menu( $args, $item, $depth ) {

	// Add sub menu toggles to the Expanded Menu with toggles.
	if ( 'primary' === $args->theme_location ) {
		if ( in_array( 'menu-item-has-children', $item->classes, true ) ) {
			$args->after = '<i class="fa fa-chevron-down gt-submenu-icon"></i>';
		} else {
			$args->after = '';
		}
	}

	return $args;

}

add_filter( 'nav_menu_item_args', 'yog_add_sub_toggles_to_main_menu', 10, 3 );
?>