<?php
function yog_display_loader()
{
    $theme_options = get_option('theme_options');
    if(isset($theme_options['loader_switch']))
    {

        if($theme_options['loader_switch'] == 'image')
        {
            if(!empty($theme_options['background_loader']['url']))
            {
                ?>
                <div id="gt-loading">
                    <div id="gt-loading-center">

                        <img src="<?php echo esc_url($theme_options['background_loader']['url']) ?>" alt="<?php esc_attr_e('loading','yog'); ?>">

                    </div>
                </div>
            <?php }
        }
        else if($theme_options['loader_switch'] == 'text')
        {
            if(!empty($theme_options['loader_text']))
            {
                $tag = $theme_options['loader_tag'];
            ?>
                <div id="gt-loading">
                    <div id="gt-loading-center">

                        <<?php echo esc_html($tag); ?> class="gt-loader-text"><?php echo esc_html($theme_options['loader_text']) ?></<?php echo esc_html($tag); ?>>

                    </div>
                  </div>
            <?php }
        }
    }
    else
    {
        ?>
        <div id="gt-loading">
            <div id="gt-loading-center">

                <img src="<?php echo YOG_URL.'/assets/img/loader.png' ?>" alt="<?php esc_attr_e('loading','yog'); ?>">

            </div>
        </div>
    <?php
    }
}

function yog_display_logo()
{
    $theme_options = get_option('theme_options');
    $logo = YOG_URL.'/assets/img/logo.png';


    if(function_exists('get_field') && get_field('key_pjos')['set_sep_logo'] == 'yes' && !empty(get_field('key_pjos')['logo_image']['url']) )
    {
        $fld = get_field('key_pjos');

            $logo = $fld['logo_image']['url'];
            ?>
            <img class="img-fluid logo" src="<?php echo esc_url($logo,'yog') ?>" alt="<?php  esc_attr_e( 'yog', 'yog' ); ?>">
        <?php

    }
    else if(isset($theme_options['logo_type']))
    {
        if($theme_options['logo_type'] == 'image')
        {
            if(!empty($theme_options['logo_url']['url']))
            {
                $logo = $theme_options['logo_url']['url'];
            }


        ?>
        <img class="img-fluid logo" src="<?php echo esc_url($logo,'yog') ?>" alt="<?php  esc_attr_e( 'yog', 'yog' ); ?>">
        <?php
        }

        if($theme_options['logo_type'] == 'text')
        {
            if(!empty($theme_options['header_logo_text']))
            {
                $text = $theme_options['header_logo_text'];
            }
            else
            {
                $text = 'yog';
            }
            if(!empty($theme_options['header_logo_tag']))
            {
                $tag = $theme_options['header_logo_tag'];
            }
            else
            {
                $tag = 'h2';
            }

        ?>
            <<?php echo esc_html($tag); ?> class="gt-logo-text"><?php echo esc_html($text); ?></<?php echo esc_html($tag); ?>>
        <?php
        }

    }
    else
    {
    ?>
        <img class="img-fluid logo" src="<?php echo esc_url($logo,'yog') ?>" alt="<?php  esc_attr_e( 'yog', 'yog' ); ?>">
    <?php
    }

}

?>