<?php
function yog_fonts_url() {
	$fonts_url = '';

	/*
	 * translators: If there are characters in your language that are not supported
	 * by Libre Franklin, translate this to 'off'. Do not translate into your own language.
	 */
	$font_families = array();


	$Josefin = _x( 'on', 'Josefin Sans font: on or off', 'yog' );
	$OpenSans = _x( 'on', 'Open+Sans font: on or off', 'yog' );



	if ( 'off' !== $Josefin )
	{
		$font_families[] = 'Josefin+Sans:wght@100;200;300;400;500;600;700';
	}
	if ( 'off' !== $OpenSans )
	{
		$font_families[] = 'Open+Sans:wght@300;400;600;700;800';
	}




		$query_args = array(
			'family'  =>   implode( '&family=', $font_families ) ,
			'subset'  =>  'latin,latin-ext' ,
			'display' => 'swap',
		);

		$fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css2' );


	return  esc_url_raw( $fonts_url, null );
}
function yog_scripts() {


    wp_enqueue_style( 'yog-fonts', yog_fonts_url(), array(), null );
    // Load Bootstrap Javascript.
	wp_enqueue_script('bootstrap', YOG_URL .'/assets/js/bootstrap.min.js', array('jquery'), '4.1.3' , true);

	wp_enqueue_script('yog-custom', YOG_URL .'/assets/js/custom.js', array('jquery'),'1.0', true);


	wp_enqueue_style('all', YOG_URL .'/assets/css/font-awesome/css/all.min.css', array(), '5.13.0', 'all');

	wp_enqueue_style('ionicons', YOG_URL .'/assets/css/ionicons.min.css', array(), '2.0.0', 'all');
	wp_enqueue_style('line-awesome', YOG_URL .'/assets/css/line-awesome.min.css', array(), '1.3.0', 'all');

    //Load Bootstrap stylesheet.
	wp_enqueue_style('bootstrap', YOG_URL .'/assets/css/bootstrap.min.css',array(), '4.1.3', 'all');

	wp_enqueue_style('animate-min', YOG_URL .'/assets/css/animate.min.css',array(), '4.0.0', 'all');
   wp_enqueue_style('yog-custom', YOG_URL .'/assets/css/custom.css',array(), '1.0', 'all');

   wp_enqueue_style('yog-woocommerce', YOG_URL .'/assets/css/woocommerce.css',array(), '1.0', 'all');
   wp_enqueue_style('yog-LearnPress', YOG_URL .'/assets/css/LearnPress.css',array(), '1.0', 'all');

	wp_enqueue_style('yog-responsive', YOG_URL .'/assets/css/responsive.css',array(), '1.0', 'all');
}
add_action( 'wp_enqueue_scripts', 'yog_scripts' , 99);


require YOG_DIR . '/inc/tgm/required_plugin.php';
require YOG_DIR . '/inc/customizer/widget.php';
require YOG_DIR . '/inc/customizer/banner.php';
require YOG_DIR . '/inc/customizer/breadcumbs.php';
require YOG_DIR . '/inc/customizer/pagination.php';
require YOG_DIR . '/inc/customizer/comments.php';
require YOG_DIR . '/inc/customizer/theme-functions.php';
