<?php
/**
 * yog functions and definitions
 *
 * Set up the theme and provides some helper functions, which are used in the
 * theme as custom template tags. Others are attached to action and filter
 * hooks in WordPress to change core functionality.
 *
 * When using a child theme you can override certain functions (those wrapped
 * in a function_exists() call) by defining them first in your child theme's
 * functions.php file. The child theme's functions.php file is included before
 * the parent theme's file, so the child theme functions would be used.
 *
 * @link https://codex.wordpress.org/Theme_Development
 * @link https://developer.wordpress.org/themes/advanced-topics/child-themes/
 *
 * Functions that are not pluggable (not wrapped in function_exists()) are
 * instead attached to a filter or action hook.
 *
 * For more information on hooks, actions, and filters,
 * {@link https://codex.wordpress.org/Plugin_API}
 *
 * @package WordPress
 * @subpackage yog
 * @since yog 1.0
 */
// template directory
define('YOG_DIR', get_template_directory());                  
// template directory uri
define('YOG_URL', get_template_directory_uri());              
define('YOG_ADMIN', admin_url());  
/**
 * Twenty Sixteen only works in WordPress 4.4 or later.
 */
if ( version_compare( $GLOBALS['wp_version'], '4.4-alpha', '<' ) ) {
	require YOG_DIR . '/inc/back-compat.php';
}
/**
 * Sets up theme defaults and registers support for various WordPress features.
 *
 * Note that this function is hooked into the after_setup_theme hook, which
 * runs before the init hook. The init hook is too late for some features, such
 * as indicating support for post thumbnails.
 */
//delete_option( "core_updater.lock" );
function yog_setup() {
	/*
	 * Make theme available for translation.
	 * Translations can be filed at WordPress.org. See: https://translate.wordpress.org/projects/wp-themes/yog
	 * If you're building a theme based on yog, use a find and replace
	 * to change 'yog' to the name of your theme in all the template files.
	 */
	 
	load_theme_textdomain( 'yog', YOG_DIR . '/languages' );
	// Add default posts and comments RSS feed links to head.
	add_theme_support( 'automatic-feed-links' );
	/*
	 * Let WordPress manage the document title.
	 * By adding theme support, we declare that this theme does not use a
	 * hard-coded <title> tag in the document head, and expect WordPress to
	 * provide it for us.
	 */
	add_theme_support( 'title-tag' );
	/*
	 * Enable support for Post Thumbnails on posts and pages.
	 *
	 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
	 */
	add_theme_support( 'post-thumbnails' );
	add_image_size( 'yog-featured-image', 2000, 1200, true );
	add_image_size( 'yog-thumbnail-avatar', 100, 100, true );
	// Set the default content width.
	$GLOBALS['content_width'] = 525;
	// This theme uses wp_nav_menu() in two locations.
	register_nav_menus( array(
		'primary'    => esc_html__( 'Primary', 'yog' ),
		'social' => esc_html__( 'Social Links Menu', 'yog' ),
		'side_menu' => esc_html__( 'Sidebar Menu', 'yog' ),
		'page_side_menu' => esc_html__( 'Page Side Menu', 'yog' ),
	) );
	/*
	 * Switch default core markup for search form, comment form, and comments
	 * to output valid HTML5.
	 */
	add_theme_support( 'html5', array(
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
	) );
	/*
	 * Enable support for Post Formats.
	 *
	 * See: https://codex.wordpress.org/Post_Formats
	 */
	add_theme_support( 'post-formats', array(
		'aside',
		'image',
		'video',
		'quote',
		'link',
		'gallery',
		'audio',
	) );
	// Add theme support for Custom Logo.
	add_theme_support( 'custom-logo', array(
		'width'       => 250,
		'height'      => 250,
		'flex-width'  => true,
	) );
	// Add theme support for selective refresh for widgets.
	add_theme_support( 'customize-selective-refresh-widgets' );
	/*
	 * This theme styles the visual editor to resemble the theme style,
	 * specifically font, colors, and column width.
 	 */
	// Define and register starter content to showcase the theme on new sites.
	$starter_content = array(
		'widgets' => array(
			// Place three core-defined widgets in the sidebar area.
			'sidebar-1' => array(
				'text_business_info',
				'search',
				'text_about',
			),
			// Add the core-defined business info widget to the footer 1 area.
			'sidebar-2' => array(
				'text_business_info',
			),
			// Put two core-defined widgets in the footer 2 area.
			'sidebar-3' => array(
				'text_about',
				'search',
			),
		),
		// Specify the core-defined pages to create and add custom thumbnails to some of them.
		'posts' => array(
			'home',
			'about' => array(
				'thumbnail' => '{{image-sandwich}}',
			),
			'contact' => array(
				'thumbnail' => '{{image-espresso}}',
			),
			'blog' => array(
				'thumbnail' => '{{image-coffee}}',
			),
			'homepage-section' => array(
				'thumbnail' => '{{image-espresso}}',
			),
		),
		// Create the custom image attachments used as post thumbnails for pages.
		'attachments' => array(
			'image-espresso' => array(
				'post_title' => esc_html_x( 'Espresso', 'Theme starter content', 'yog' ),
				'file' => '/assets/images/espresso.jpg', // URL relative to the template directory.
			),
			'image-sandwich' => array(
				'post_title' => esc_html_x( 'Sandwich', 'Theme starter content', 'yog' ),
				'file' => '/assets/images/sandwich.jpg',
			),
			'image-coffee' => array(
				'post_title' => esc_html_x( 'Coffee', 'Theme starter content', 'yog' ),
				'file' => '/assets/images/coffee.jpg',
			),
		),
		// Default to a static front page and assign the front and posts pages.
		'options' => array(
			'show_on_front' => 'page',
			'page_on_front' => '{{home}}',
			'page_for_posts' => '{{blog}}',
		),
		// Set the front page section theme mods to the IDs of the core-registered pages.
		'theme_mods' => array(
			'panel_1' => '{{homepage-section}}',
			'panel_2' => '{{about}}',
			'panel_3' => '{{blog}}',
			'panel_4' => '{{contact}}',
		),
		// Set up nav menus for each of the two areas registered in the theme.
		'nav_menus' => array(
			// Assign a menu to the "top" location.
			'primary' => array(
				'name' => esc_html__( 'Primary', 'yog' ),
				'items' => array(
					'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.
					'page_about',
					'page_blog',
					'page_contact',
				),
			),
			// Assign a menu to the "social" location.
			'social' => array(
				'name' => esc_html__( 'Social Links Menu', 'yog' ),
				'items' => array(
					'link_yelp',
					'link_facebook',
					'link_twitter',
					'link_instagram',
					'link_email',
				),
			),
		),
	);
	/**
	 * Filters yog array of starter content.
	 *
	 * @since yog 1.1
	 *
	 * @param array $starter_content Array of starter content.
	 */
	$starter_content = apply_filters( 'yog_starter_content', $starter_content );
	add_theme_support( 'starter-content', $starter_content );
}
add_action( 'after_setup_theme', 'yog_setup' );
function yog_enqueue_comments_reply() {
    if( is_singular() && comments_open() && ( get_option( 'thread_comments' ) == 1) ) {
        // Load comment-reply.js (into footer)
        wp_enqueue_script( 'comment-reply', '/wp-includes/js/comment-reply.min.js', array(), false, true );
    }
}
add_action(  'wp_enqueue_scripts', 'yog_enqueue_comments_reply' );
add_action(
    'after_setup_theme',
    function() {
        add_theme_support( 'html5', [ 'script', 'style' ] );
    }
);
add_action('wp_loaded', 'yog_prefix_output_buffer_start');
function yog_prefix_output_buffer_start() { 
    ob_start("yog_prefix_output_callback"); 
}
function yog_prefix_output_callback($buffer) {
    return preg_replace( "%[ ]type=[\'\"]text\/(javascript|css)[\'\"]%", '', $buffer );
}
function yog_add_woocommerce_support() {
    add_theme_support( 'woocommerce' );
 	// add_theme_support( 'wc-product-gallery-zoom' );
    add_theme_support( 'wc-product-gallery-lightbox' );
   add_theme_support( 'wc-product-gallery-slider' );
}
add_action( 'after_setup_theme', 'yog_add_woocommerce_support' );
add_filter('loop_shop_columns', 'yog_theme_loop_columns', 99);
function yog_theme_loop_columns() {
	        $theme_options = get_option('theme_options');
	       
	        if(isset($theme_options['shop_column_num']) && !empty($theme_options['shop_column_num']))
	        {
	            return $theme_options['shop_column_num'];
	        }
	        else
	        {
	           return 3; // 3 products per row 
	        }
	        
	    }
// add_filter( 'learn-press/override-templates', false );
add_filter( 'learn-press/override-templates', function(){ return true; } );
add_action('admin_menu', 'remove_comment_support');

function remove_comment_support() {
    remove_post_type_support( 'lp_course', 'comments' );
    remove_post_type_support( 'lp_lesson', 'comments' );
    remove_post_type_support( 'lp_quiz', 'comments' );
    remove_post_type_support( 'lp_question', 'comments' );
}
add_filter('upload_mimes',  'yog_file_types_to_uploads');
function yog_file_types_to_uploads($file_types){
$new_filetypes = array();
$new_filetypes['svg'] = 'svg+xml';
$file_types = array_merge($file_types, $new_filetypes );
return $file_types;
}
require_once YOG_DIR . '/inc/customizer/init.php';
require_once YOG_DIR . '/inc/template-tags.php';
require_once YOG_DIR . '/inc/template-functions.php';
require_once YOG_DIR . '/inc/color-patterns.php';
require_once YOG_DIR . '/inc/custom-header.php';
require_once YOG_DIR . '/inc/customizer.php';
require_once YOG_DIR . '/inc/icon-functions.php';
?>