<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package WordPress
 * @subpackage yog
 * @since 1.0
 * @version 1.0
 */

get_header(); 
$theme_options = get_option('theme_options');  
?>
<div class="container">
	<div id="primary" class="content-area">
		<main id="main" class="site-main">
			<div class="gt-not-found">
				<div class="page-content">
					<div class="row">
						<div class="col-sm-12">
							<div class="gt-error-block">

							
							<div class="gt-errot-text"><?php esc_html_e( '404', 'yog' ); ?></div>
							<?php
							if(isset($theme_options['title_404']) && !empty($theme_options['title_404']))
							{ 
							?>
							<h2><?php echo  esc_html($theme_options['title_404']); ?></h2>
							<?php } 
							else
							{
							?>
							<h2><?php echo  esc_html__('Oops! This Page is Not Found.' ,'yog'); ?></h2>
						<?php }

						if(isset($theme_options['description_404']) && !empty($theme_options['description_404']))
						{
							?>

							<p><?php echo esc_html( $theme_options['description_404'] ); ?></p> 
						<?php } 
						else
						{
						?>
						<p><?php echo esc_html__( 'Please go back to home and try to find out once again.' , 'yog' ); ?></p> 
						<?php } ?>
							<div class="gt-btn-block">

								
							 	<div class="gt-btn-container">
					              <a href="<?php echo esc_url(home_url()); ?>" class="gt-button">
					                <div class="gt-button-block">
					                  <span class="gt-button-line-left"></span>
					                  <span  class="gt-button-text"><?php esc_html_e('Back to Home', 'yog'); ?></span>
					                                   
					                </div>  
					              </a>
            					</div>	              
								</div>    
							
							</div>
						</div>
					</div>
				</div><!-- .page-content -->
			</div><!-- .error-404 -->
		</main><!-- #main -->
	</div><!-- #primary -->
</div><!-- .container -->

<?php get_footer();