<?php
function subscribe() {
	register_widget( 'subscribe' );
}
add_action( 'widgets_init', 'subscribe' );
/*-------------------------------------------
		ptonic Contact Information widget
		--------------------------------------------*/
		class subscribe extends WP_Widget {
			function __construct() {
				parent::__construct(
			// Base ID of your widget
					'subscribe',
			// Widget name will appear in UI
					esc_html('subscribe', 'architek'),
			// Widget description
					array( 'description' => esc_html( 'subscribe files  ', 'architek' ), )
				);
			}
	// Creating widget front-end
			public function widget( $args, $instance ) {
				if ( ! isset( $args['widget_id'] ) ) {
					$args['widget_id'] = $this->id;
				}
				$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
				$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
				$desc = isset( $instance['desc'] ) ? $instance['desc'] : false;
				$code = isset( $instance['code'] ) ? $instance['code'] : false;

				$theme_options = get_option('theme_options');
				?>
				<div class="widget">
					<?php if ( $title ) {
						echo ($args['before_title'] . $title . $args['after_title']);
					} ?>
					<?php
					if($desc)
					{ 
						?>
						<p><?php echo esc_html($desc); ?></p>
					<?php } ?>
					<?php $var = do_shortcode( $instance['code'] ); 
					echo $var;
					?>
				</div>	
				<?php

			}
	// Widget Backend
			public function form( $instance ) {
				$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
				$desc = isset( $instance['desc'] ) ? esc_html($instance['desc'])  : false;	
				$code = isset( $instance['code'] ) ? esc_html($instance['code'])  : false;	
				?>
				<p><label for="<?php echo esc_html($this->get_field_id( 'title','architek' )); ?>"><?php esc_html_e( 'Title:','architek' ); ?></label>
					<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','architek' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','architek')); ?>" type="text" value="<?php echo esc_html($title,'architek'); ?>" /></p>
					<p>
						<textarea class="widefat" id="<?php echo esc_html($this->get_field_id( 'desc','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'desc','yog-core')); ?>" placeholder="<?php esc_attr__('Enter description text here' , 'yog-core') ?>"><?php echo esc_html($desc); ?></textarea>
					</p>
					<p>
						<textarea class="widefat" id="<?php echo esc_html($this->get_field_id( 'code','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'code','yog-core')); ?>" placeholder="<?php esc_attr__('Enter codeription text here' , 'yog-core') ?>"><?php echo($code); ?></textarea>
					</p>
					<?php
				}
	// Updating widget replacing old instances with new
				public function update( $new_instance, $old_instance ) {
					$instance = array();
					$instance['title'] = sanitize_text_field( $new_instance['title'] );
					$instance['desc'] = sanitize_text_field( $new_instance['desc'] );
					$instance['code'] = sanitize_text_field( $new_instance['code'] );


					return $instance;
				}
			}
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/