<?php
function architeck_contact_info() {
    register_widget( 'gt_Contacts' );
}
add_action( 'widgets_init', 'architeck_contact_info' );
/*-------------------------------------------
		architeck Contact Information widget 
--------------------------------------------*/
class gt_Contacts extends WP_Widget {
 
	function __construct() {
		parent::__construct(
 
			// Base ID of your widget
			'gt_Contacts', 
			
			// Widget name will appear in UI
			esc_html('sidebar contact', 'architeck'), 
 
			// Widget description
			array( 'description' => esc_html( 'architeck Contact. ', 'architeck' ), ) 
		);
	}
 
	// Creating widget front-end
	
	public function widget( $args, $instance ) {
		global $wp_registered_sidebars;
		
		
        if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$phone = isset( $instance['phone'] ) ? $instance['phone'] : false;
		$email = isset( $instance['email'] ) ? $instance['email'] : false;
		$address = isset( $instance['address'] ) ? $instance['address'] : false;
		
		$theme_options = get_option('theme_options');
		// print_r($theme_options);
		
		//$args['after_widget'];
		/* here add extra display item  */ 
		?>
		<div class="widget">
			<?php if ( $title ) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<div class="row">
				<div class="col-sm-12">
					<ul class="pt-contact">
						<?php
						if ( $address ) : 
						?>
						<?php
						if(!empty($theme_options['yog_address']))
						{ 
						?>						
						<li>
							<i class="fa fa-map-marker"></i>
							<span>
								<?php echo esc_html($theme_options['yog_address']); ?>
							</span>
						</li>
						<?php } ?>
						<?php endif; ?>
						<?php
						if ( $phone ) : 
						?>
						<?php
						if(!empty($theme_options['yog_phone']))
						{ 
						?>
						<li>
						
						<a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_phone']); ?>"><i class="fa fa-phone"></i>
							<span><?php echo esc_html($theme_options['yog_phone']); ?></span>
						</a>
						</li>
						<?php } ?>
						<?php endif; ?>
						<?php
						if ( $email ) : 
						?>
						<?php
						if(!empty($theme_options['yog_email']))
						{ 
						?>
						<li>
						
						<a href="mailto:<?php echo esc_html($theme_options['yog_email']); ?>"><i class="fa fa-envelope"></i><span><?php echo esc_html($theme_options['yog_email']); ?></span></a>
						</li>
						<?php } ?>
						<?php endif; ?>
						
					</ul>
				</div>
			
			<div class="gt-footer-social">


                        <ul>
                     <?php 
                     if(isset($theme_options['yog_social']))
                     {
                     foreach ($theme_options['yog_social'] as $key => $value) {
                     if(!empty($value))
                     {
                     ?>
                     <li><a href="<?php echo esc_url($value); ?>"><i class="fab <?php echo esc_attr($key); ?>"></i></a></li>

                  <?php } } }?>
                  </ul>
                     


                  </div>
				</div>
			</div>	
	<?php	
	}
         
	// Widget Backend 
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$phone    = isset( $instance['phone'] ) ? (bool) $instance['phone'] : false;
		$email = isset( $instance['email'] ) ? (bool) $instance['email'] : false;
		$address = isset( $instance['address'] ) ? (bool) $instance['address'] : false;	
		?>
		
		<p><label for="<?php echo esc_html($this->get_field_id( 'title','architeck' )); ?>"><?php esc_html_e( 'Title:','architeck' ); ?></label>
		<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','architeck' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','architeck')); ?>" type="text" value="<?php echo esc_html($title,'architeck'); ?>" /></p>
		
		<p><input class="checkbox" type="checkbox"<?php checked( $phone ); ?> id="<?php echo esc_html($this->get_field_id( 'phone','architeck' )); ?>" name="<?php echo esc_html($this->get_field_name( 'phone','architeck' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'phone','architeck' )); ?>"><?php esc_html_e( 'Display Phone Number?','architeck' ); ?></label></p>
		<p><input class="checkbox" type="checkbox"<?php checked( $email ); ?> id="<?php echo esc_html($this->get_field_id( 'email','architeck' )); ?>" name="<?php echo esc_html($this->get_field_name( 'email','architeck' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'email','architeck' )); ?>"><?php esc_html_e( 'Display Email?','architeck' ); ?></label></p>
		<p><input class="checkbox" type="checkbox"<?php checked( $address ); ?> id="<?php echo esc_html($this->get_field_id( 'address','architeck' )); ?>" name="<?php echo esc_html($this->get_field_name( 'address','architeck' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'address','architeck' )); ?>"><?php esc_html_e( 'Display Address?','architeck' ); ?></label></p>
		
		<?php 					
	}
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['phone'] = isset( $new_instance['phone'] ) ? (bool) $new_instance['phone'] : false;
		$instance['email'] = isset( $new_instance['email'] ) ? (bool) $new_instance['email'] : false;
		$instance['address'] = isset( $new_instance['address'] ) ? (bool) $new_instance['address'] : false;		
        return $instance;
	}
} 
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/	
