<?php
function yog_recent_post_widgets() {
	register_widget( 'Gt_Recent_Post' );
}
add_action( 'widgets_init', 'yog_recent_post_widgets' );
/*-------------------------------------------
ptonic Contact Information widget
--------------------------------------------*/
class Gt_Recent_Post extends WP_Widget {
	function __construct() {
		parent::__construct(
// Base ID of your widget
			'Gt_Recent_Post',
// Widget name will appear in UI
			esc_html('yog_ Recent Post', 'yog-core'),
// Widget description
			array( 'description' => esc_html( 'yog_ most recent Posts. ', 'yog-core' ), )
		);
	}
// Creating widget front-end
	public function widget( $args, $instance ) {
		if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}
		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number ) {
			$number = 5;
		}
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;
//$args['after_widget'];
		/* here add extra display item  */
		?>
		<div class="gt-widget-menu widget">
			<?php if ( $title ) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<?php
			$args = array( 'post_type' => 'post', 'posts_per_page' => $number, );
			$loop = new WP_Query( $args );
			while ( $loop->have_posts() )
			{
				$loop->the_post();
				$image_url = wp_get_attachment_url( get_post_thumbnail_id($loop->ID) );
				$final_url = Pt_Widiget_Post($image_url,'layout-1' , 'true' , '0' );

				?>
				<div class="gt-foote-recent-post">
					<div class="gt-foote-recent-post-media">
						<a href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
							 <img src="<?php echo esc_url($final_url); ?>" alt="<?php esc_attr_e('yog-sidebar-logo','yog'); ?>"></a>
						</div>
						<div class="gt-foote-recent-post-info">
							<?php
							$archive_year  = get_the_time( 'Y' );
							$archive_month = get_the_time( 'm' );
							$archive_day   = get_the_time( 'd' );
							?>
							<h6><a href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
						<?php the_title(); ?>
						</a></h6>
							<a href="<?php echo esc_url( get_day_link( $archive_year, $archive_month, $archive_day ) ); ?>" class="gt-post-date"><i class="fa fa-calendar"></i><?php echo esc_html( get_the_date('F',get_the_ID()));?> <span><?php echo esc_html( get_the_date('d',get_the_ID())); ?></span>, <?php echo esc_html( get_the_date('Y',get_the_ID()));?> </a>

						</div>
					</div>
					<?php
				}
				wp_reset_query();
				?>
			</div>
			<?php
		}
// Widget Backend
		public function form( $instance ) {
			$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			$tag     = isset( $instance['tag'] ) ? esc_attr( $instance['tag'] ) : 'h2';
			$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
			$show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
			?>
			<p><label for="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>"><?php esc_html_e( 'Title:','yog-core' ); ?></label>
				<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','yog-core')); ?>" type="text" value="<?php echo esc_html($title,'yog-core'); ?>" /></p>
				<p><label for="<?php echo esc_html($this->get_field_id( 'number','yog-core' )); ?>"><?php esc_html_e( 'Number of posts to show:','yog-core' ); ?></label>
					<input class="tiny-text" id="<?php echo esc_html($this->get_field_id( 'number','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'number','yog-core' )); ?>" type="number" step="1" min="1" value="<?php echo esc_html($number,'yog-core'); ?>" size="3" /></p>
					<?php
				}
// Updating widget replacing old instances with new
				public function update( $new_instance, $old_instance ) {
					$instance = array();
					$instance['title'] = sanitize_text_field( $new_instance['title'] );
					$instance['number'] = (int) $new_instance['number'];
					$instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
					return $instance;
				}
			}
/*---------------------------------------
Class wpb_widget ends here
----------------------------------------*/