<?php
function yog_times_info() {
    register_widget( 'Gt_TIMES' );
}
add_action( 'widgets_init', 'yog_times_info' );

/*-------------------------------------------
		yog Contact Information widget 
--------------------------------------------*/
class Gt_TIMES extends WP_Widget {
 
	function __construct() {
		parent::__construct(
 
			// Base ID of your widget
			'Gt_timeing', 
			
			// Widget name will appear in UI
			esc_html('time', 'yog'), 
 
			// Widget description
			array( 'description' => esc_html( 'yog Contact. ', 'yog' ), ) 
		);
	}
 
	// Creating widget front-end
	
	public function widget( $args, $instance ) {

		global $wp_registered_sidebars;
		
		
        if ( ! isset( $args['widget_id'] ) )
         {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
		
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$Monday = isset( $instance['Monday'] ) ? $instance['Monday'] : false;
		$saturday = isset( $instance['saturday'] ) ? $instance['saturday'] : false;
		$Sunday = isset( $instance['Sunday'] ) ? $instance['Sunday'] : false;
		$holiday = isset( $instance['holiday'] ) ? $instance['holiday'] : false;
		$tuseday = isset( $instance['tuseday'] ) ? $instance['tuseday'] : false;
		$wednesday = isset( $instance['wednesday'] ) ? $instance['wednesday'] : false;
		$Thursday = isset( $instance['Thursday'] ) ? $instance['Thursday'] : false;
		$Friday = isset( $instance['Friday'] ) ? $instance['Friday'] : false;
		$theme_options = get_option('theme_options');
		//$args['after_widget'];

		/* here add extra display item  */ 
		?>
		<div class="widget">
			<?php if ( $title ) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<div class="row">
				<div class="col-sm-12">
					<ul class="gt-contact-time">
						<?php
						if ( $Monday ) : 
						?>
						<?php
						if(!empty($theme_options['Monday']))
						{ 
						?>						
						<li>
							<span>Monday</span>
							<span><?php echo esc_html($theme_options['Monday']);?></span>
						</li>
						<?php } ?>
						<?php endif; ?>
						<?php
						if ( $saturday ) : 
						?>
						<?php
						// print_r($theme_options['saturday']);
						if(!empty($theme_options['saturday']))
						{ 
						?>
						<li>
							<span>Saturday</span>
							<span><?php echo esc_html($theme_options['saturday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>

						<?php
						if ( $Sunday ) : 
						?>
						<?php
						// print_r($theme_options['sunday']);
						if(!empty($theme_options['sunday']))
						{ 
						?>
						<li>
							<span>Sunday</span>
							<span><?php echo esc_html($theme_options['sunday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>
						

						<?php
						if ( $tuseday ) : 
						?>
						<?php
						// print_r($theme_options['holiday']);
						if(!empty($theme_options['Tuesday']))
						{ 
						?>
						<li>
							<span>Tuseday</span>
							<span><?php echo esc_html($theme_options['Tuesday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>

						<?php
						if ( $wednesday ) : 
						?>
						<?php
						// print_r($theme_options['holiday']);
						if(!empty($theme_options['wednesday']))
						{ 
						?>
						<li>
							<span>wednesday</span>
							<span><?php echo esc_html($theme_options['wednesday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>


						<?php
						if ( $Thursday ) : 
						?>
						<?php
						// print_r($theme_options['holiday']);
						if(!empty($theme_options['Thursday']))
						{ 
						?>
						<li>
							<span>Thursday</span>
							<span><?php echo esc_html($theme_options['Thursday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>


						<?php
						if ( $Friday ) : 
						?>
						<?php
						// print_r($theme_options['holiday']);
						if(!empty($theme_options['Friday']))
						{ 
						?>
						<li>
							<span>Friday</span>
							<span><?php echo esc_html($theme_options['Friday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>

						<?php
						if ( $holiday ) : 
						?>
						<?php
						// print_r($theme_options['holiday']);
						if(!empty($theme_options['holiday']))
						{ 
						?>
						<li>
							<span>On Public Holidays</span>
							<span><?php echo esc_html($theme_options['holiday']); ?></span>
						</li>
						<?php } ?>
						<?php endif; ?>
						
					</ul>
				</div>
			</div>
			</div>	
	<?php	
	}
         
	// Widget Backend 
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$Monday    = isset( $instance['Monday'] ) ? (bool) $instance['Monday'] : false;

		$saturday = isset( $instance['saturday'] ) ? (bool) $instance['saturday'] : false;
		$Sunday = isset( $instance['Sunday'] ) ? (bool) $instance['Sunday'] : false;	
		$holiday = isset( $instance['holiday'] ) ? (bool) $instance['holiday'] : false;	
		$tuseday = isset( $instance['tuseday'] ) ? (bool) $instance['tuseday'] : false;	
		$wednesday = isset( $instance['wednesday'] ) ? (bool) $instance['wednesday'] : false;	
		$tuseday = isset( $instance['tuseday'] ) ? (bool) $instance['tuseday'] : false;	
		$Thursday = isset( $instance['Thursday'] ) ? (bool) $instance['Thursday'] : false;	
		$Friday = isset( $instance['Friday'] ) ? (bool) $instance['Friday'] : false;	
		?>
		
		<p><label for="<?php echo esc_html($this->get_field_id( 'title','yog' )); ?>"><?php esc_html_e( 'Title:','yog' ); ?></label>
		<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','yog')); ?>" type="text" value="<?php echo esc_html($title,'yog'); ?>" /></p>
		
		<p><input class="checkbox" type="checkbox"<?php checked( $Monday ); ?> id="<?php echo esc_html($this->get_field_id( 'Monday','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'Monday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'Monday','yog' )); ?>"><?php esc_html_e( 'Monday','yog' ); ?></label></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $saturday ); ?> id="<?php echo esc_html($this->get_field_id( 'saturday','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'saturday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'saturday','yog' )); ?>"><?php esc_html_e( 'saturday','yog' ); ?></label></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $Sunday ); ?> id="<?php echo esc_html($this->get_field_id( 'Sunday','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'Sunday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'Sunday','yog' )); ?>"><?php esc_html_e( 'Display Sunday','yog' ); ?></label></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $holiday ); ?>
		 id="<?php echo esc_html($this->get_field_id( 'holiday','yog' )); ?>"
		 name="<?php echo esc_html($this->get_field_name( 'holiday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'holiday','yog' )); ?>"><?php esc_html_e( 'Display holiday Status','yog' ); ?></label></p>


		<p><input class="checkbox" type="checkbox"<?php checked( $wednesday ); ?>
		 id="<?php echo esc_html($this->get_field_id( 'wednesday','yog' )); ?>"
		 name="<?php echo esc_html($this->get_field_name( 'wednesday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'wednesday','yog' )); ?>"><?php esc_html_e( 'wednesday','yog' ); ?></label></p>
		
		<p><input class="checkbox" type="checkbox"<?php checked( $tuseday ); ?>
		 id="<?php echo esc_html($this->get_field_id( 'tuseday','yog' )); ?>"
		 name="<?php echo esc_html($this->get_field_name( 'tuseday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'tuseday','yog' )); ?>"><?php esc_html_e( 'tuseday','yog' ); ?></label></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $Thursday ); ?>
		 id="<?php echo esc_html($this->get_field_id( 'Thursday','yog' )); ?>"
		 name="<?php echo esc_html($this->get_field_name( 'Thursday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'Thursday','yog' )); ?>"><?php esc_html_e( 'Thursday','yog' ); ?></label></p>

		<p><input class="checkbox" type="checkbox"<?php checked( $Friday ); ?>
		 id="<?php echo esc_html($this->get_field_id( 'Friday','yog' )); ?>"
		 name="<?php echo esc_html($this->get_field_name( 'Friday','yog' )); ?>" />
		<label for="<?php echo esc_html($this->get_field_id( 'Friday','yog' )); ?>"><?php esc_html_e( 'Friday','yog' ); ?></label></p>

		<?php 					
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['Monday'] = isset( $new_instance['Monday'] ) ? (bool) $new_instance['Monday'] : false;
		$instance['saturday'] = isset( $new_instance['saturday'] ) ? (bool) $new_instance['saturday'] : false;
		$instance['Sunday'] = isset( $new_instance['Sunday'] ) ? (bool) $new_instance['Sunday'] : false;		
		$instance['holiday'] = isset( $new_instance['holiday'] ) ? (bool) $new_instance['holiday'] : false;
		$instance['tuseday'] = isset( $new_instance['tuseday'] ) ? (bool) $new_instance['tuseday'] : false;		
		$instance['wednesday'] = isset( $new_instance['wednesday'] ) ? (bool) $new_instance['wednesday'] : false;		
		$instance['Thursday'] = isset( $new_instance['Thursday'] ) ? (bool) $new_instance['Thursday'] : false;		
		$instance['Friday'] = isset( $new_instance['Friday'] ) ? (bool) $new_instance['Friday'] : false;		
        return $instance;
	}
} 
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/	
