<?php
function yog_time_info() {
    register_widget( 'Gt_Timing' );
}
add_action( 'widgets_init', 'yog_time_info' );

/*-------------------------------------------
		gym Contact Information widget 
--------------------------------------------*/
class Gt_Timing extends WP_Widget {
 
	function __construct() {
		parent::__construct(
 
			// Base ID of your widget
			'Gt_Timing', 
			
			// Widget name will appear in UI
			esc_html('gym Timing', 'yog-core'), 
 
			// Widget description
			array( 'description' => esc_html( 'gym Timing. ', 'yog-core' ), ) 
		);
	}
	// Creating widget front-end
	public function widget( $args, $instance ) {

		global $wp_registered_sidebars;
		
		
        if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
		
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		
		//$args['after_widget'];

		/* here add extra display item  */ 
		?>
		<div class="widget">
			<?php if ( $title ) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<div class="row">
				<div class="col-sm-12">
					<ul class="gt-footer-time">
						<li>Sunday : 10-2</li>
						<li>Monday : 10-2</li>
						<li>Tuesday : 10-2</li>
						<li>Wednesday : 10-2</li>
						<li>Thursday : 10-2</li>
						<li>Friday : 10-2</li>
						<li>Saturday : 10-2</li>						
					</ul>
				</div>
			</div>
			</div>	
	<?php	
	}
         
	// Widget Backend 
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
			
		?>
		
		<p><label for="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>"><?php esc_html_e( 'Title:','yog-core' ); ?></label>
		<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','yog-core')); ?>" type="text" value="<?php echo esc_html($title,'yog-core'); ?>" /></p>
		
		
		<?php 					
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
			
        return $instance;
	}
} 
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/	
