<?php
function yog_footer_logo() {
    register_widget( 'Gt_Footer_Logo' );
}
add_action( 'widgets_init', 'yog_footer_logo' );

/*-------------------------------------------
		yog-core Contact Information widget 
--------------------------------------------*/
class Gt_Footer_Logo extends WP_Widget {
 
	function __construct() {
		parent::__construct(
 
			// Base ID of your widget
			'Gt_Footer_Logo', 
			
			// Widget name will appear in UI
			esc_html('Footer Logo', 'yog-core'), 
 
			// Widget description
			array( 'description' => esc_html( 'Footer Logo. ', 'yog-core' ), ) 
		);
	}
 
	// Creating widget front-end
	
	public function widget( $args, $instance ) {

		global $wp_registered_sidebars;
		$theme_options = get_option('theme_options');

		// print_r($theme_options['yog_social']);

		
        if ( ! isset( $args['widget_id'] ) ) {
			$args['widget_id'] = $this->id;
		}

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
		
		/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );

		$footer_about = isset( $instance['footer_about'] ) ? $instance['footer_about'] : false;
		
		if(!empty($theme_options['logo_footer']['url']))
		{
			$logo = $theme_options['logo_footer']['url'];
		}
		else
		{
			$logo = 'http://gym.peacefulthemes.com/wp-content/themes/gym/assets/img/logo.png';
		}

		/* here add extra display item  */ 
		?>
		<div class="widget">
			<?php if ( $title ) {
				// echo ($args['before_title'] . $title . $args['after_title']);
			//} ?>
			<div class="row">
				<div class="col-sm-12">
					<img src="<?php echo esc_url($logo) ?>" class="gt-footer-logo" alt="<?php esc_attr_e('gym-footer-logo','yog-core'); ?>">
					<?php
					if($footer_about)
					{ 
						?>
						<p><?php echo esc_html($footer_about); ?></p>
					<?php } ?>

					<div class="gt-footer-social">


                        <ul>
                     <?php 
                     if(isset($theme_options['yog_social']))
                     {
                     foreach ($theme_options['yog_social'] as $key => $value) {
                     if(!empty($value))
                     {
                     ?>
                     <li><a href="<?php echo esc_url($value); ?>"><i class="fab <?php echo esc_attr($key); ?>"></i></a></li>

                  <?php } } }?>
                  </ul>
                     



				</div>

					<?php } ?>
						
					</div>
				</div>
			</div>	
		
	<?php	
	}
         
	// Widget Backend 
	public function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		
		$footer_about = isset( $instance['footer_about'] ) ? esc_html($instance['footer_about'])  : false;	
		?>
		
		<p><label for="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>"><?php esc_html_e( 'Title:','yog-core' ); ?></label>
		<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','yog-core')); ?>" type="text" value="<?php echo esc_html($title,'yog-core'); ?>" /></p>
		
		<p>
			<textarea class="widefat" id="<?php echo esc_html($this->get_field_id( 'footer_about','yog-core' )); ?>" name="<?php echo esc_html($this->get_field_name( 'footer_about','yog-core')); ?>" placeholder="<?php esc_attr__('Enter description text here' , 'yog-core') ?>"><?php echo esc_html($footer_about); ?></textarea>
		</p>
		
		<?php 					
	}

	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = sanitize_text_field( $new_instance['title'] );
		$instance['footer_about'] = sanitize_text_field( $new_instance['footer_about'] );
		
        return $instance;
	}
} 
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/	
