<?php
function yog_contact_info() {
	register_widget( 'Gt_Contact' );
}
add_action( 'widgets_init', 'yog_contact_info' );
/*-------------------------------------------
		yog_ Contact Information widget 
		--------------------------------------------*/
		class Gt_Contact extends WP_Widget {

			function __construct() {
				add_action('admin_enqueue_scripts', array($this, 'scripts'));
				parent::__construct(

			// Base ID of your widget
					'Gt_Contact', 

			// Widget name will appear in UI
					esc_html('yog_ Contact', 'yog'), 

			// Widget description
					array( 'description' => esc_html( 'yog_ Contact. ', 'yog' ), ) 
				);
			}

	// Creating widget front-end
			public function scripts()
			{
				wp_enqueue_script( 'media-upload' );
				wp_enqueue_media();
				wp_enqueue_script('our_admin', get_template_directory_uri() . '/assets/js/yog_-custom.js', array('jquery'));
			}

			public function widget( $args, $instance ) {
				global $wp_registered_sidebars;


				if ( ! isset( $args['widget_id'] ) ) {
					$args['widget_id'] = $this->id;
				}
				$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : false;
				/** This filter is documented in wp-includes/widgets/class-wp-widget-pages.php */
				$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
				$phone = isset( $instance['phone'] ) ? $instance['phone'] : false;
				$email = isset( $instance['email'] ) ? $instance['email'] : false;
				$address = isset( $instance['address'] ) ? $instance['address'] : false;
				$text = isset( $instance['text'] ) ? $instance['text'] : false;
				$image = ! empty( $instance['image'] ) ? $instance['image'] : false;

				$theme_options = get_option('theme_options');
				?>
				<div class="widget widget-port-1">
					<?php if ( $title ) {
						echo ($args['before_title'] . $title . $args['after_title']);
					} 
					?>
					<?php ob_start();
					if($image): ?>
						<img src="<?php echo esc_url($image); ?>" alt="">
					<?php endif; 
					ob_end_flush(); ?>
					<div class="row">
						<div class="col-sm-12">
							<div class="gt-contact">
								<?php
								if ( $address ) : 
									?>
									<?php
									if(!empty($theme_options['yog_address']))
									{ 
										?>	
                                        <h5>Address</h5>
										<div class="gt-address">
                                            
											
											<span class="address">
												<?php echo esc_html($theme_options['yog_address']); ?>
											</span>
										</div>
									<?php } ?>
								<?php endif; ?>
								<?php
								if ( $phone ) : 
									?>
									<?php
									if(!empty($theme_options['yog_phone']))
									{ 
										?>
										<h5>Phone</h5>

										<div class="gt-phone">
											<a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_phone']); ?>">
												<span><?php echo esc_html($theme_options['yog_phone']); ?></span>
											</a>
										</div>
									<?php } ?>
								<?php endif; ?>
								<?php
								if ( $email ) : 
									?>
									<?php
									if(!empty($theme_options['yog_email']))
									{ 
										?>
										<h5>Email</h5>

										<div class="gt-email">
											<a href="mailto:<?php echo esc_html($theme_options['yog_email']); ?>"><span><?php echo esc_html($theme_options['yog_email']); ?></span></a>
										</div>
									<?php } ?>
								<?php endif; ?>
								<!-- text -->
								<?php if ( $text ) : 
									?>
									<?php
									if(!empty($theme_options['yog_text']))
									{ 
										?>
										<li>

											<a href="tel:<?php echo str_replace(str_split('(),-" '), '',$theme_options['yog_text']); ?>"><i class="fa fa-text"></i>
												<span><?php echo esc_html($theme_options['yog_text']); ?></span>
											</a>
										</li>
									<?php } ?>
								<?php endif; ?>
								<!-- text end -->

							</div>
						</div>
					</div>
				</div>	
				<?php	
			}

	// Widget Backend 
			public function form( $instance ) {
				$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
				$phone    = isset( $instance['phone'] ) ? (bool) $instance['phone'] : false;
				$email = isset( $instance['email'] ) ? (bool) $instance['email'] : false;
				$address = isset( $instance['address'] ) ? (bool) $instance['address'] : false;	
				$text = isset( $instance['text'] ) ? (bool) $instance['text'] : false;
				$image = ! empty( $instance['image'] ) ? $instance['image'] : false;
				?>

				<p><label for="<?php echo esc_html($this->get_field_id( 'title','yog' )); ?>"><?php esc_html_e( 'Title:','yog' ); ?></label>
					<input class="widefat" id="<?php echo esc_html($this->get_field_id( 'title','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'title','yog')); ?>" type="text" value="<?php echo esc_html($title,'yog'); ?>" /></p>

					<p><input class="checkbox" type="checkbox"<?php checked( $phone ); ?> id="<?php echo esc_html($this->get_field_id( 'phone','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'phone','yog' )); ?>" />
						<label for="<?php echo esc_html($this->get_field_id( 'phone','yog' )); ?>"><?php esc_html_e( 'Display Phone Number?','yog' ); ?></label></p>
						<p><input class="checkbox" type="checkbox"<?php checked( $email ); ?> id="<?php echo esc_html($this->get_field_id( 'email','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'email','yog' )); ?>" />
							<label for="<?php echo esc_html($this->get_field_id( 'email','yog' )); ?>"><?php esc_html_e( 'Display Email?','yog' ); ?></label></p>
							<p><input class="checkbox" type="checkbox"<?php checked( $address ); ?> id="<?php echo esc_html($this->get_field_id( 'address','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'address','yog' )); ?>" />
								<label for="<?php echo esc_html($this->get_field_id( 'address','yog' )); ?>"><?php esc_html_e( 'Display Address?','yog' ); ?></label></p>
								<p><input class="checkbox" type="checkbox"<?php checked( $text ); ?> id="<?php echo esc_html($this->get_field_id( 'text','yog' )); ?>" name="<?php echo esc_html($this->get_field_name( 'text','yog' )); ?>" />
									<label for="<?php echo esc_html($this->get_field_id( 'text','yog' )); ?>"><?php esc_html_e( 'Display Address?','yog' ); ?></label></p>
									<p>
										<label for="<?php echo $this->get_field_id( 'image' ); ?>"><?php _e( 'Image:' ); ?></label>
										<input class="widefat" id="<?php echo $this->get_field_id( 'image' ); ?>" name="<?php echo $this->get_field_name( 'image' ); ?>" type="text" value="<?php echo esc_url( $image ); ?>" />
										<button class="upload_image_button button button-primary">Upload Image</button>
									</p>

									<?php 					
								}
	// Updating widget replacing old instances with new
								public function update( $new_instance, $old_instance ) {
									$instance = array();
									$instance['title'] = sanitize_text_field( $new_instance['title'] );
									$instance['phone'] = isset( $new_instance['phone'] ) ? (bool) $new_instance['phone'] : false;
									$instance['email'] = isset( $new_instance['email'] ) ? (bool) $new_instance['email'] : false;
									$instance['address'] = isset( $new_instance['address'] ) ? (bool) $new_instance['address'] : false;		
									$instance['text'] = isset( $new_instance['text'] ) ? (bool) $new_instance['text'] : false;
									$instance['image'] = ( ! empty( $new_instance['image'] ) ) ? $new_instance['image'] : false;

									return $instance;
								}
							} 
/*---------------------------------------
		Class wpb_widget ends here
		----------------------------------------*/	
