<?php
function dwn()
{
	register_widget('Download');
}
add_action('widgets_init', 'dwn');
/*-------------------------------------------
ptonic Contact Information widget
--------------------------------------------*/
class Download extends WP_Widget
{
	public function __construct()
	{
		parent::__construct(
         // Base ID of your widget
			'Download',
         // Widget name will appear in UI
			esc_html('dwn', 'architek'),
         // Widget description
			array('description' => esc_html('download files  ', 'architek'))
		);
	}
   // Creating widget front-end
	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}
		$title  = (!empty($instance['title'])) ? $instance['title'] : false;
		$title  = apply_filters('widget_title', $title, $instance, $this->id_base);
		$button = isset($instance['button']) ? $instance['button'] : false;
		$url    = isset($instance['url']) ? $instance['url'] : false;
		?>
		<div class="gt-widget-button-1">

		<?php if ( $title ) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
		<div class="gt-btn-container">

			<?php
			if (isset($url)) 
			{
				$url = $url;
			} else {
				$url = "#";
			}
			?>
			<a href="<?php echo esc_url($url); ?>" target="_blank" class="gt-button">
				<div class="gt-button-block">
					<span class="gt-button-line-left"></span>
					<?php
					if (isset($button)) 
					{
						$text = $button;
					} else {
						$text = 'Get Quote';
					}
					?>
					<span  class="gt-button-text"><?php echo esc_html($text); ?></span>
				</div>
			</a>
		</div>
	</div>
		<?php
	}
   // Widget Backend
	public function form($instance)
	{
		$title = isset($instance['title']) ? esc_attr($instance['title']) : false;
		$button = isset($instance['button']) ? esc_attr($instance['button']) : false;
		$url = isset($instance['url']) ? esc_attr($instance['url']) : false;
		?>
		<p><label for="<?php echo esc_html($this->get_field_id('title', 'architek')); ?>"><?php esc_html_e('Title:', 'architek');?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('title', 'architek')); ?>" name="<?php echo esc_html($this->get_field_name('title', 'architek')); ?>" type="text" value="<?php echo esc_html($title, 'architek'); ?>" /></p>


		<p><label for="<?php echo esc_html($this->get_field_id('button', 'architek')); ?>"><?php esc_html_e('button:', 'architek');?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('button', 'architek')); ?>" name="<?php echo esc_html($this->get_field_name('button', 'architek')); ?>" type="text" value="<?php echo esc_html($button, 'architek'); ?>" /></p>


			<p><label for="<?php echo esc_html($this->get_field_id('url', 'architek')); ?>"><?php esc_html_e('url:', 'architek');?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('url', 'architek')); ?>" name="<?php echo esc_html($this->get_field_name('url', 'architek')); ?>" type="text" value="<?php echo esc_html($url, 'architek'); ?>" /></p>




			<?php
		}
   // Updating widget replacing old instances with new
		public function update($new_instance, $old_instance)
		{
			$instance          = array();
			$instance['title'] = sanitize_text_field($new_instance['title']);
			$instance['button'] = isset( $new_instance['button'] ) ? $new_instance['button'] : false;
			$instance['url'] = isset( $new_instance['url'] ) ? $new_instance['url'] : false;
			return $instance;
		}
	}
/*---------------------------------------
Class wpb_widget ends here
----------------------------------------*/