<?php
/*
 * Sidebar Options
*/

Redux::setSection($options, array(
    'title' => esc_html__('Sidebars', 'yog-core') ,
    'id' => 'editer-sidebar',
    'icon' => 'eicon-sidebar',
    'customizer_width' => '500px',
));

// sidebar Page Settings
Redux::setSection( $options, array(
    'title' => esc_html__('Blog Sidebars','yog-core'),
    'id'    => 'sidebar-section',
        
    'subsection' => true,
    'desc'  => wp_kses( __( 'Choose structures (No Sidebar , Right Sidebar, Left Sidebar) for your sidebar section.
            <br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog-core' ), array( 'br' => array() ) ),            
    'fields'=> array(

        array(
            'id' => 'info_general'.rand(10,1000),
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Blog Page Sidebar Options', 'yog-core') ,
            
        ) ,

        array(
            'id' => 'section-general'.rand(10,1000),
            'type' => 'section',
            'indent' => true
        ) ,       

        array(
            'id'        => 'pt_blog_sidebar',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Blog Page','yog-core' ),
            'subtitle'     => esc_html__( 'Choose Sidebar Option For Blog Page','yog-core' ),
            
            'options'   => array(
                                'no_sidebar' => array( 'title' => esc_html__( 'No Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/nosidebar.png' ), 
                                'left_sidebar' => array( 'title' => esc_html__( 'Left Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/right-sidebar.png' ), 
                                'right_sidebar' => array( 'title' => esc_html__( 'Right Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/left-sidebar.png' ), 
                                
                                
                            ),
            'default'   => 'right_sidebar',
        ),

              

        // Single Blog Options
        array(
            'id' => 'info_general'.rand(10,1000),
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),

            'title' => __('Blog Single Page Sider Options', 'yog-core') ,
        ) ,

        array(
            'id' => 'section-general'.rand(10,1000),
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id'        => 'single_blog_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Blog Singal Page Sidebar Setting','yog-core' ),
            
            'options'   => array(


                'no_sidebar' => array( 'title' => esc_html__( 'No Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/nosidebar.png' ), 
                                'left_sidebar' => array( 'title' => esc_html__( 'Left Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/right-sidebar.png' ), 
                                'right_sidebar' => array( 'title' => esc_html__( 'Right Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/left-sidebar.png' ), 
                
                                
                            ),
            'default'   => 'right_sidebar',
        ),     
     

    )
    ));

// Archive Page
Redux::setSection( $options, array(
    'title' => esc_html__('Archive','yog-core'),
    'id'    => 'sidebar-archive',
        
    'subsection' => true,
    'desc'  => wp_kses( __( 'Choose structures (No Sidebar , Right Sidebar, Left Sidebar) for your sidebar section.
            <br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog-core' ), array( 'br' => array() ) ),            
    'fields'=> array(
        array(
            'id' => 'info_general'.rand(10,1000),
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Archive Page Sidebar Options', 'yog-core') ,           
        ) ,

        array(
            'id' => 'section-general'.rand(10,1000),
            'type' => 'section',
            'indent' => true
        ) ,       

        array(
            'id'        => 'archive_blog_sidebar',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Archive Page','yog-core' ),
            'subtitle'     => esc_html__( 'Choose Sidebar Option For Archive  Blog Page','yog-core' ),
            
            'options'   => array(
                                'no_sidebar' => array( 'title' => esc_html__( 'No Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/nosidebar.png' ), 
                                'left_sidebar' => array( 'title' => esc_html__( 'Left Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/right-sidebar.png' ), 
                                'right_sidebar' => array( 'title' => esc_html__( 'Right Sidebar','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/left-sidebar.png' ), 
                                
                                
                            ),
            'default'   => 'right_sidebar',
        ),
    )
));

