<?php
/*
* Header Options
*/

Redux::setSection($options, array(
    'title' => esc_html__('Header', 'yog-core') ,
    'id' => 'section_230ac35',
    'icon' => 'eicon-header',
    'customizer_width' => '500px',
));

Redux::setSection($options, array(
    'title' => esc_html__('Layout', 'yog-core') ,
    'id' => 'section_09d4601',
    'subsection' => true,
    'desc' => esc_html__('Section For Customize Header', 'yog-core') ,
    'fields' => array(

        array(
            'id' => 'info__09d4601',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Header Layout Options', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_09d4601',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id'        => 'pt_header_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Header Layout','yog-core' ),


            'options'   => array(
                'default' => array( 'title' => esc_html__( 'Default','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/header/default.png' ), 
                'style-one' => array( 'title' => esc_html__( 'Style One','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/header/style-one.png' ), 
                'style-two' => array( 'title' => esc_html__( 'Style Two','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/header/style-two.png' ), 



            ),
            'default'   => 'default',
        ),

        array(
            'id' => 'header_search_enable',
            'type' => 'button_set',
            'title' => esc_html__('Enable Search Button', 'yog-core') ,

            'options' => array(
                'yes' => esc_html__('Yes', 'yog-core') ,
                'no' => esc_html__('No', 'yog-core')

            ) ,
            'default' => esc_html__('yes', 'yog-core'),
            'required' => array('pt_header_layout', '=', array('default' ,'style-two' ) ) ,
        ) ,

        array(
            'id' => 'header_action_enable',
            'type' => 'button_set',
            'title' => esc_html__('Enable Action Button', 'yog-core') ,

            'options' => array(
                'yes' => esc_html__('Yes', 'yog-core') ,
                'no' => esc_html__('No', 'yog-core')

            ) ,
            'default' => esc_html__('no', 'yog-core'),
            'required' => array('pt_header_layout', '=', array('default' ,'style-one' )  ) ,
        ) ,

        array(
            'id' => 'action_btn_text',
            'type' => 'text',
            'title' => esc_html__('Action Button Text', 'yog-core') ,
            'required' => array('header_action_enable', '=', array('yes' ) ) ,

        ) ,

        array(
            'id' => 'action_btn_url',
            'type' => 'text',
            'title' => esc_html__('Action Button Url', 'yog-core') ,
            'required' => array('header_action_enable', '=', array('yes' ) ) ,

        ) ,

        array(
            'id' => 'action_back_color',
            'type' => 'color',
            'title' => esc_html__('Action Button Background', 'yog-core') ,         

            'mode' => 'background',
            'required' => array(
                'header_action_enable',
                '=',
                'yes'
            ) ,
            'transparent' => false
        ) ,
          array(
            'id' => 'action_back_hover_color',
            'type' => 'color',
            'title' => esc_html__('Action Button Hover Background', 'yog-core') ,         

            'mode' => 'background',
            'required' => array(
                'header_action_enable',
                '=',
                'yes'
            ) ,
            'transparent' => false
        ) ,

         array(
            'id' => 'action_text_color',
            'type' => 'color',
            'title' => esc_html__('Action Button Text', 'yog-core') ,         

            'mode' => 'background',
            'required' => array(
                'header_action_enable',
                '=',
                'yes'
            ) ,
            'transparent' => false
        ) ,
            array(
            'id' => 'action_text_hover_color',
            'type' => 'color',
            'title' => esc_html__('Action Button Text Hover', 'yog-core') ,         

            'mode' => 'background',
            'required' => array(
                'header_action_enable',
                '=',
                'yes'
            ) ,
            'transparent' => false
        ) ,

        array(
            'id' => 'header_contact_enable',
            'type' => 'button_set',
            'title' => esc_html__('Enable Contact Number', 'yog-core') ,

            'options' => array(
                'yes' => esc_html__('Yes', 'yog-core') ,
                'no' => esc_html__('No', 'yog-core')

            ) ,
            'default' => esc_html__('yes', 'yog-core'),
            'required' => array('pt_header_layout', '=', array('style-one' ) ) ,
        ) ,

        array(
            'id' => 'header_contact_text',
            'type' => 'text',
            'title' => esc_html__('Contact Text', 'yog-core') ,
            'required' => array('header_contact_enable', '=', array('yes' ) ) ,

        ) ,
//Sidebar
        array(
            'id' => 'header_sidebar_enable',
            'type' => 'button_set',
            'title' => esc_html__('Enable Siderbar', 'yog-core') ,

            'options' => array(
                'yes' => esc_html__('Yes', 'yog-core') ,
                'no' => esc_html__('No', 'yog-core')

            ) ,
            'default' => esc_html__('yes', 'yog-core'),
            'required' => array('pt_header_layout', '=', array('style-two' ) ) ,
        ) ,
        array(
            'id' => 'sidebar_logo',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Image', 'yog-core') ,
            'read-only' => false,
            'required' => array(
                'header_sidebar_enable',
                '=',
                'yes'
            ) ,
        ) ,   

        array(
            'id' => 'sidebar_logo_dimenation',
            'type' => 'dimensions',
            'units' => array(
                'em',
                'px',
                '%'
) , // You can specify a unit value. Possible: px, em, %
'units_extended' => 'true', // Allow users to select any type of unit
'title' => esc_html__('Sidebar Logo (Width/Height) Option', 'yog-core') ,            
'required' => array(
    'header_sidebar_enable',
    '=',
    'yes'
) ,

) ,   

        array(
            'id'        => 'sidebar_desc',
            'type'      => 'textarea',   
            'title'    => __('Enter Description', 'yog-core'),              
            'desc' => esc_html__('Enter Text', 'yog-core') ,
            'required' => array(
                'header_sidebar_enable',
                '=',
                'yes'
            ) ,
        ), 

//Sidebar


        array(
            'id' => 'header_back_opt_switch',
            'type' => 'button_set',
            'title' => esc_html__('Background', 'yog-core') ,

            'options' => array(
                'none' => esc_html__('none', 'yog-core') ,
                'image' => esc_html__('Image', 'yog-core') ,
                'color' => esc_html__('Color', 'yog-core'),
                'transparent' => esc_html__('Transparent', 'yog-core'),
                'dark' => esc_html__('Dark', 'yog-core'),
                'white' => esc_html__('White', 'yog-core')
            ) ,
            'default' => esc_html__('none', 'yog-core')
        ) ,
        array(
            'id' => 'header_back_img',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Image', 'yog-core') ,
            'read-only' => false,
            'required' => array(
                'header_back_opt_switch',
                '=',
                'image'
            ) ,
        ) ,        

        array(
            'id' => 'header_back_color',
            'type' => 'color',
            'title' => esc_html__('Color', 'yog-core') ,         

            'mode' => 'background',
            'required' => array(
                'header_back_opt_switch',
                '=',
                'color'
            ) ,
            'transparent' => false
        ) ,
        array(
            'id' => 'info__09d461',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Header Menu Color', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_09d601',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id' => 'menu_normal_color',
            'type' => 'color',
            'title' => esc_html__('Normal Color', 'yog-core') ,  
            'mode' => 'background',
            'transparent' => false
        ) ,

        array(
            'id' => 'menu_active_color',
            'type' => 'color',
            'title' => esc_html__('Active Color', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ) ,

        array(
            'id' => 'sub_menu_background_color',
            'type' => 'color',
            'title' => esc_html__('Sub menu Background Color', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ) ,
         array(
            'id' => 'sub_menu_border_bottom_color',
            'type' => 'color',
            'title' => esc_html__('Sub menu Border Bottom Color', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ) ,

        array(
            'id' => 'info__09d4',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Responsive Menu Color', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_09d601',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id' => 'toggle_button',
            'type' => 'color',
            'title' => esc_html__('Toggle Button', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ),
        array(
            'id' => 'toggle_bar',
            'type' => 'color',
            'title' => esc_html__('Toggle Bar', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ),
         array(
            'id' => 'responsive_active_color',
            'type' => 'color',
            'title' => esc_html__('Active  Color', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ) ,


         array(
            'id' => 'responsive_active_background',
            'type' => 'color',
            'title' => esc_html__('Active Background Color', 'yog-core') ,
            'mode' => 'background',
            'transparent' => false
        ) ,


    )
));

//Top Header Options
Redux::setSection($options, array(
    'title' => esc_html__('Top Header', 'yog-core') ,
    'id' => 'section_05b1956',    
    'subsection' => true,
    'desc' => esc_html__('Section For Customize Top header.', 'yog-core') ,

    'fields' => array(
        array(
            'id' => 'info__05b1956',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Top Header Setting', 'yog-core') ,
        ) ,
        array(
            'id' => 'section_1b5c143',
            'type' => 'section',
            'indent' => true
        ) ,


        array(
            'id' => 'top_header_enable',
            'type' => 'button_set',
            'title' => esc_html__('Enable Top Header', 'yog-core') ,

            'options' => array(
                'yes' => esc_html__('Yes', 'yog-core') ,
                'no' => esc_html__('No', 'yog-core')

            ) ,
            'default' => esc_html__('no', 'yog-core')
        ) ,

        array(
            'id'        => 'pt_top_header_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Top Header Layout','yog-core' ),


            'options'   => array(
                'social-right' => array( 'title' => '', 'img' => YOG_PLUGIN_URL. '/assests/img/header/social-right.png' ), 
                'social-left' => array( 'title' => '', 'img' => YOG_PLUGIN_URL. '/assests/img/header/social-left.png' ), 



            ),
            'default'   => 'default',
            'required' => array(
                'top_header_enable',
                '=',
                'yes'
            ) ,
        ),


        // array(
        //     'id' => 'top_header_text',
        //     'type' => 'text',
        //     'title' => esc_html__('Action Text', 'yog-core') ,
        //     'required' => array(
        //         'pt_top_header_layout',
        //         '=',
        //         'social-style-two'
        //     ) ,


        // ) ,

        array(
            'id'       => 'yog_social_switch',
            'type'     => 'switch', 
            'title'    => __('Display Socail Media In Header', 'yog'),
            'default'  => true,

        ),

        array(
            'id'       => 'yog_contact_switch',
            'type'     => 'switch', 
            'title'    => __('Display Contact In Header', 'yog'),

            'default'  => true,
        ),


        array(
            'id' => 'top_header_back_type',
            'type' => 'button_set',
            'title' => esc_html__('Top Header Background Type', 'yog-core') ,

            'options' => array(
                'none' => esc_html__('none','yog-core'),
                'image' => esc_html__('Image', 'yog-core') ,
                'color' => esc_html__('color', 'yog-core'),
                'transparent' => esc_html__('Transparent', 'yog-core'),
                'dark' => esc_html__('Dark', 'yog-core'),
                'white' => esc_html__('White', 'yog-core')

            ) ,
            'default' => esc_html__('none', 'yog-core'),
            'required' => array(
                'top_header_enable',
                '=',
                'yes'
            ) ,
        ) ,
        array(
            'id' => 'top_header_back_color',
            'type' => 'color',
            'title' => esc_html__('Top Header Background Color', 'yog-core') ,

            'default' => '#ffffff',
            'mode' => 'background',
            'transparent' => false,
            'required' => array(
                'top_header_back_type',
                '=',
                'color'
            ) ,
        ) ,

        array(
            'id' => 'top_header_back_img',
            'type' => 'media',
            'title' => esc_html__('Image', 'yog-core') ,            
            'default' => '#ffffff',
            'url'=>true,
            'required' => array(
                'top_header_back_type',
                '=',
                'image'
            ) ,
        ) ,

        array(
            'id' => 'top_header_text_color',
            'type' => 'color',
            'title' => esc_html__('Top Header Text Color', 'yog-core') ,            
            'mode' => 'background',
            'transparent' => false,
            'required' => array(
                'top_header_enable',
                '=',
                'yes'
            ) ,
        ) ,

        array(
            'id' => 'top_header_text_hover_color',
            'type' => 'color',
            'title' => esc_html__('Top Header Text Hover Color', 'yog-core') ,           
            'mode' => 'background',
            'transparent' => false,
            'required' => array(
                'top_header_enable',
                '=',
                'yes'
            ) ,
        ) ,

      

        array(
            'id' => 'top_header_icon_hover_color',
            'type' => 'color',
            'title' => esc_html__('Top Header Icon Hover Background Color', 'yog-core') ,           
            'mode' => 'background',
            'transparent' => false,
            'required' => array(
                'top_header_enable',
                '=',
                'yes'
            ) ,
        ) ,


    )
));

//Sticky Header Options
Redux::setSection($options, array(
    'title' => esc_html__('Sticky Header', 'yog-core') ,
    'id' => 'section_00142ab',
    'subsection' => true,
    'desc' => esc_html__('Section For Customize Stikcy header.', 'yog-core') ,
    'fields' => array(

        array(
            'id' => 'info__00142ab',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Sticky Header Settings', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_general_ac21601',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id' => 'sticky_header_enable',
            'title' => esc_html__('Enable Sticky Header', 'yog-core') ,
            'type' => 'switch',
            'default' => true,
        ) ,

    )
));




?>