<?php
/*
 * Footer Options
 */

Redux::setSection( $options, array(
    'title' => esc_html__( 'Footer', 'yog' ),
    'id'    => 'footer-editor',
    'icon'  => 'eicon-footer',
    'customizer_width' => '500px',
) );

Redux::setSection( $options, array(
    'title' => esc_html__('Footer Logo','yog'),
    'id'    => 'footer-logo',
    
    'subsection' => true,
    'desc'  => esc_html__('This section contains options for footer.','yog'),
    'fields'=> array(

      array(
            'id' => 'info_L6N7VDM05M',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('This sectin contain options for Footer logo', 'yog-core') ,
        ) ,

        array(
            'id' => 'indentL6N7VDM05M',
            'type' => 'section',
            'indent' => true
        ) ,
        
        array(
            'id'       => 'logo_footer',         
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Footer Logo','yog'),
            'read-only'=> false,
            'subtitle' => esc_html__( 'Upload Footer Logo image for your Website. Otherwise site title will be displayed in place of Logo.','yog'),
        ), 

        array(
            'id'             => 'footerlogo-dimensions',
            'type'           => 'dimensions',
            'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',  // Allow users to select any type of unit
            'title'          => esc_html__( 'Footer Logo (Width/Height) Option', 'yog' ),
            'subtitle'       => esc_html__( 'Allow your users to choose width, height, and/or unit.', 'yog' ),
            'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'yog' ),
           
        ),

        array(
            'id'       => 'logo_footer_img',         
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Footer image','yog'),
            'read-only'=> false,
            'subtitle' => esc_html__( 'Upload Footer  image for your Website. Otherwise site title will be displayed in place of Logo.','yog'),
        ), 

        array(
            'id'             => 'footerlogo-dimensions-img',
            'type'           => 'dimensions',
            'units'          => array( 'em', 'px', '%' ),    // You can specify a unit value. Possible: px, em, %
            'units_extended' => 'true',  // Allow users to select any type of unit
            'title'          => esc_html__( 'Footer image (Width/Height) Option', 'yog' ),
            'subtitle'       => esc_html__( 'Allow your users to choose width, height, and/or unit.', 'yog' ),
            'desc'           => esc_html__( 'You can enable or disable any piece of this field. Width, Height, or Units.', 'yog' ),
           
        ),

    )
));  

Redux::setSection( $options, array(
    'title' => esc_html__('Footer Option','yog'),
    'id'    => 'footer-section',
    
    'subsection' => true,    
    'fields'=> array(

        array(
            'id' => 'info_N7VDM05M',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('This section contains options for footer', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_N7VDM05M',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id'        => 'yog_footer_top',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Display Footer Top','yog'),
            'subtitle' => esc_html__( 'Display Footer Top On All page', 'yog' ),
            'options'   => array(
                            'yes' => esc_html__('Yes','yog'),
                            'no' => esc_html__('No','yog')
                        ),
            'default'   => esc_html__('yes','yog')
        ),
        
        array(
            'id'        => 'yog_footer_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Footer Layout Type','yog' ),
            'subtitle'  => wp_kses( __( '<br />Choose among these structures (1column, 2column and 3column) for your footer section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog' ), array( 'br' => array() ) ),            
            'options'   => array(
                                '1' => array( 'title' => esc_html__( 'Footer Layout 1','yog' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/footer_first.png' ),
                                '2' => array( 'title' => esc_html__( 'Footer Layout 2','yog' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/footer_second.png' ),
                                '3' => array( 'title' => esc_html__( 'Footer Layout 3','yog' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/footer_third.png' ),
                                '4' => array( 'title' => esc_html__( 'Footer Layout 4','yog' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/footer_four.png' ),    
                                                           
                            ),
            'default'   => '4',
        ),
         array(
            'id' => 'footer_back_opt_switch',
            'type' => 'button_set',
            'title' => esc_html__('Background', 'yog-core') ,
            
            'options' => array(
                'none' => esc_html__('none', 'yog-core') ,
                'image' => esc_html__('Image', 'yog-core') ,
                'color' => esc_html__('Color', 'yog-core'),                
            ) ,
            'default' => esc_html__('none', 'yog-core')
        ) ,
         array(
            'id' => 'footer_back_img',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Image', 'yog-core') ,
            'read-only' => false,
            'required' => array(
                'footer_back_opt_switch',
                '=',
                'image'
            ) ,
        ) ,        

        array(
            'id' => 'footer_back_color',
            'type' => 'color',
            'title' => esc_html__('Color', 'yog-core') ,         
            
            'mode' => 'background',
            'required' => array(
                'footer_back_opt_switch',
                '=',
                'color'
            ) ,
            'transparent' => false
        ) ,
    )
));

Redux::setSection( $options, array(
    'title'      => esc_html__( 'Footer Copyright', 'yog' ),
    'id'         => 'footer-copyright',
    
    'subsection' => true,
    'fields'     => array(
        array(
            'id' => 'info_7VDM05M',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('This section contains options Footer Copyright', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_7VDM05M',
            'type' => 'section',
            'indent' => true
        ) ,
        array(
            'id'        => 'yog_copyright_text',
            'type'      => 'textarea',
            'title'     => esc_html__( 'Copyright Text','yog'),
            'default'   => esc_html__( 'Copyright 2020 yog_ All Rights Reserved.','yog'),
        ),

        array(
            'id'        => 'yog_copyright_link',
            'type'      => 'text',
            'title'     => esc_html__( 'Copyright Text','yog'),
            'default'   => '#',
        ),

    )) 
);

Redux::setSection( $options, array(
    'title'      => esc_html__( 'Subscribe', 'yog' ),
    'id'         => 'yog_-subscribe',
    
    'subsection' => true,
    'fields'     => array(

        array(
            'id' => 'info_7VM05M',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('This section contains options Subscription Block', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_7VM05M',
            'type' => 'section',
            'indent' => true
        ) ,

        array(
            'id'        => 'yog_footer_subscribe',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Display Subscribe','yog'),
            'subtitle' => esc_html__( 'Display Subscribe On All page', 'yog' ),
            'options'   => array(
                            'yes' => esc_html__('Yes','yog'),
                            'no' => esc_html__('No','yog')
                        ),
            'default'   => esc_html__('no','yog')
        ),

          array(
            'id' => 'subscribe_img',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Subscription Image', 'yog-core') ,
            'read-only' => false,                        
            'required'  => array( 'yog_footer_subscribe', '=', 'yes' ),
        ) ,

        array(
            'id'        => 'yog_subscribe_title',
            'type'      => 'text',
            'title'     => esc_html__( 'Subscribe Title','yog'),
            'required'  => array( 'yog_footer_subscribe', '=', 'yes' ),
            
        ),

        array(
            'id'        => 'yog_copyright_description',
            'type'      => 'textarea',
            'title'     => esc_html__( 'Subscribe Description','yog'),
            'required'  => array( 'yog_footer_subscribe', '=', 'yes' ),
            
        ),

        array(
            'id'        => 'yog_subscribe_shortcode',
            'type'      => 'text',
            'title'     => esc_html__( 'Subscribe Shortcode','yog'),
            'subtitle'  => wp_kses( __( '<br />Put you Mailchimp for WP Shortcode here','yog' ), array( 'br' => array() ) ),
            'required'  => array( 'yog_footer_subscribe', '=', 'yes' ),
        ),
    )) 
);