<?php
/*
 * Blog Page Options
*/
Redux::setSection($options, array(
    'title' => esc_html__('Page', 'yog-core') ,
    'id' => 'section_dab925e',
    'icon' => 'eicon-product-pages',
    'customizer_width' => '1000px',
));

// Blog Page Settings
Redux::setSection( $options, array(
    'title' => esc_html__('Blog Page Settings','yog-core'),
    'id'    => 'section_0beceba',
    'subsection' => true,
    'desc'  => esc_html__('This section contains options for Pages.','yog-core'),
    'fields'=> array(
        array(
            'id' => 'info__0beceba',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),

            'title' => __('Blog Page Options', 'yog-core') ,
        ) ,

        array(
            'id' => 'indent_0beceba',
            'type' => 'section',
            'indent' => true
        ) ,      

        array(
            'id'       => 'blog_btn_text',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Button Name', 'yog-core' ),
            'subtitle' => esc_html__( 'Change Blog Button Name in blog page and singal blog page', 'yog-core' ),
            'default'  => esc_html__('Read More','yog-core' ),
        ),

        array(
            'id'        => 'blog_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Blog page Setting','yog-core' ),
            'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar, 1column, 2column and 3column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog-core' ), array( 'br' => array() ) ),            
            'options'   => array(
                                
                                'one-column' => array( 'title' => esc_html__( 'One Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/one-column.png' ), 
                                'two-column' => array( 'title' => esc_html__( 'Two Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ), 
                                'three-column' => array( 'title' => esc_html__( 'Three Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ),
                                 'four-column' => array( 'title' => esc_html__( 'Four Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ),                                
                            ),
            'default'   => 'one-column',
        ),
         array(
            'id'        => 'archive_blog_layout',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Archive page Setting','yog-core' ),
            'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar, 1column, 2column and 3column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog-core' ), array( 'br' => array() ) ),            
            'options'   => array(
                                
                                'one-column' => array( 'title' => esc_html__( 'One Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/one-column.png' ), 
                                'two-column' => array( 'title' => esc_html__( 'Two Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ), 
                                'three-column' => array( 'title' => esc_html__( 'Three Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ),
                                 'four-column' => array( 'title' => esc_html__( 'Four Columns','yog-core' ), 'img' => YOG_PLUGIN_URL. '/assests/img/options/two-column.png' ),                                
                            ),
            'default'   => 'one-column',
        ),
        array(
            'id'        => 'enable_comment',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Comments','yog-core'),
            'subtitle' => esc_html__( 'Turn on to display comments.','yog-core'),
            'options'   => array(
                            'yes' => esc_html__('On','yog-core'),
                            'no' => esc_html__('Off','yog-core')
                        ),
            'default'   => esc_html__('yes','yog-core')
        ),

        
    )
    ));
Redux::setSection( $options, array(
        'title' => esc_html__('404','yog-core'),
        'id'    => 'fourzerofour-section',
        
        'subsection' => true,
        'desc'  => esc_html__('This section contains options for 404.','yog-core'),
        'fields'=> array(
            array(
                'id' => 'info_general'.rand(10,1000),
                'type' => 'info',
                'style' => 'custom',
                'color' => sanitize_hex_color($color),
    
                'title' => __('404 Page Options', 'yog-core') ,
            ) ,
    
            array(
                'id' => 'section-general'.rand(10,1000),
                'type' => 'section',
                'indent' => true
            ) ,   
            
    
            array(
                'id'        => 'title_404',
                'type'      => 'text',
                'title'     => esc_html__( '404 Page Title','yog-core'),
                'default'   => esc_html__( '404 Error','yog-core' )
            ),
            array(
                'id'        => 'description_404',
                'type'      => 'textarea',
                'title'     => esc_html__( '404 Page Description','yog-core'),
                'default'   => esc_html__( 'Oops! This Page is Not Found.','yog-core' )
            ),
        )) 
    );   
?>