<?php
/*
 * blog Options
 */
$options;
Redux::setSection( $options, array(
    'title' => esc_html__( 'Blog', 'yog' ),
    'id'    => 'editor',
    'icon'  => 'el el-pencil',
    'customizer_width' => '500px',
) );

Redux::setSection( $options, array(
    'title' => esc_html__('General Blogs','yog'),
    'id'    => 'blog-section',
    'icon'       => 'el el-ok',
    'subsection' => true,
    'desc'  => esc_html__('This section contains options for blog.','yog'),
    'fields'=> array(

        array(
            'id'       => 'yog_blog_banner_image',         
            'type'     => 'media',
            'url'      => true,
            'title'    => esc_html__( 'Blog Page Default Banner Image','yog'),
            'read-only'=> false,
            'subtitle' => esc_html__( 'Upload banner image for your Website. Otherwise blank field will be displayed in place of this section.','yog'),
        ),

        array(
            'id'       => 'blog_btn',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Button Name', 'yog' ),
            'subtitle' => esc_html__( 'Change Blog Button Name in blog page and singal blog page', 'yog' ),
            'default'  => esc_html__('Read More','yog' ),
        ),

        array(
            'id'        => 'yog_blog',
            'type'      => 'image_select',
            'title'     => esc_html__( 'Blog page Setting','yog' ),
            'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar, 1column, 2column and 3column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog' ), array( 'br' => array() ) ),            
            'options'   => array(
                                '1' => array( 'title' => esc_html__( 'Right Sidebar','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/right-side.jpg' ), 
                                '2' => array( 'title' => esc_html__( 'Left Sidebar','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/left-side.jpg' ),
                                '3' => array( 'title' => esc_html__( 'One Columns','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/single-column.jpg' ), 
                                '4' => array( 'title' => esc_html__( 'Two Columns','yog' ), 'img' =>YOG_PLUGIN_URL. '/assets/img/two-column.jpg' ), 
                                '5' => array( 'title' => esc_html__( 'Three Columns','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/three-column.jpg' ),                                
                            ),
            'default'   => '1',
        ),

        array(
            'id'        => 'yog_display_pagination',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Previous/Next Pagination','yog'),
            'subtitle' => esc_html__( 'Turn on to display the previous/next post pagination for blog page.','yog'),
            'options'   => array(
                            'yes' => esc_html__('On','yog'),
                            'no' => esc_html__('Off','yog')
                        ),
            'default'   => esc_html__('yes','yog')
        ),

        array(
            'id'        => 'yog_display_image',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Featured Image on Blog Archive Page','yog'),
            'subtitle' => esc_html__( 'Turn on to display featured images on the blog or archive pages.','yog'),
            'options'   => array(
                            'yes' => esc_html__('On','yog'),
                            'no' => esc_html__('Off','yog')
                        ),
            'default'   => esc_html__('yes','yog')
        ),
    )
    ));

Redux::setSection( $options, array(
    'title'      => esc_html__( 'Blog Singal Post', 'yog' ),
    'id'         => 'basic',
    'icon'       => 'el el-ok',
    'subsection' => true,
    'fields'     => array(

            array(
                'id'        => 'yog_blog_type',
                'type'      => 'image_select',
                'title'     => esc_html__( 'Blog Singal page Setting','yog' ),
                'subtitle'  => wp_kses( __( '<br />Choose among these structures (Right Sidebar, Left Sidebar and 1column) for your blog section.<br />To filling these column sections you should go to appearance > widget.<br />And put every widget that you want in these sections.','yog' ), array( 'br' => array() ) ),            
                'options'   => array(
                                    '1' => array( 'title' => esc_html__( 'Right Sidebar','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/right-side.jpg' ),
                                    '2' => array( 'title' => esc_html__( 'Left Sidebar','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/left-side.jpg' ), 
                                    '3' => array( 'title' => esc_html__( 'Full Width','yog' ), 'img' => YOG_PLUGIN_URL. '/assets/img/single-column.jpg' ),                                
                                ),
                'default'   => '1',
            ),

            array(
                'id'        => 'yog_display_comment',
                'type'      => 'button_set',
                'title'     => esc_html__( 'Comments','yog'),
                'subtitle' => esc_html__( 'Turn on to display comments.','yog'),
                'options'   => array(
                                'yes' => esc_html__('On','yog'),
                                'no' => esc_html__('Off','yog')
                            ),
                'default'   => esc_html__('yes','yog')
            ),

            array(
                'id'       => 'comment_btn',
                'type'     => 'text',
                'title'    => esc_html__( 'Comment Button Name', 'yog' ),
                'subtitle' => esc_html__( 'Change Comment Button Name in singal blog page', 'yog' ),
                'default'  => esc_html__('Read More','yog' ),
            ),

        )) 
    );

   
?>