<?php
/*
 * Banner Options
 */

Redux::setSection( $options, array(
    'title' => esc_html__('Banner','yog-core'),
    'id'    => 'section_c93098b',
    'icon'  => 'eicon-banner',
    'desc'  => esc_html__('Section For Customize Breadcrumbs.','yog-core'),
    'fields'=> array(

       array(
            'id' => 'info_c93098b',
            'type' => 'info',
            'style' => 'custom',
            'color' => sanitize_hex_color($color),
            'title' => __('Banner Layout Options', 'yog-core') ,
        ) ,
        array(
            'id' => 'indent_c8138f9',
            'type' => 'section',
            'indent' => true        ) ,

     
        array(
            'id'        => 'enable_banner',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Enable Banner','yog-core'),
            'options'   => array(
                            'yes' => esc_html__('Yes','yog-core'),
                            'no' => esc_html__('No','yog-core')
                        ),
            'default'   => esc_html__('yes','yog-core')
        ),

        array(
            'id'        => 'display_breadcrumbs',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Display Breadcrumbs on Banner','yog-core'),
            'options'   => array(
                            'yes' => esc_html__('Yes','yog-core'),
                            'no' => esc_html__('No','yog-core')
                        ),
            'required'  => array( 'enable_banner', '=', 'yes' ),
         
                'default'   => esc_html__('yes','yog-core')
        ),

        array(
            'id'        => 'display_title',
            'type'      => 'button_set',
            'title'     => esc_html__( 'Display Title on Banner','yog-core'),
            'options'   => array(
                            'yes' => esc_html__('Yes','yog-core'),
                            'no' => esc_html__('No','yog-core')
                        ),
            'required'  => array( 'enable_banner', '=', 'yes' ),
         
            'default'   => esc_html__('yes','yog-core')
        ),

        array(
            'id'            => 'breadcrumbs_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Set Breadcrumb Color', 'yog-core' ),
            'subtitle'      => esc_html__( 'Choose Title Color', 'yog-core' ),
            'mode'          => 'background',
            'required'  => array( 'enable_banner', '=', 'yes' ),
            'transparent'   => false
        ),

         array(
            'id'            => 'breadcrumbs_hover_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Set Breadcrumb Hover Color', 'yog-core' ),
            'subtitle'      => esc_html__( 'Choose Title Color', 'yog-core' ),
            'mode'          => 'background',
            'required'  => array( 'enable_banner', '=', 'yes' ),
            'transparent'   => false
        ),
        array(
            'id'            => 'title_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Set Title Color', 'yog-core' ),
            'subtitle'      => esc_html__( 'Choose Title Color', 'yog-core' ),
            'mode'          => 'background',
            'required'  => array( 'enable_banner', '=', 'yes' ),
            'transparent'   => false
        ),

        array(
            'id'       => 'banner_back_type',
            'type'     => 'button_set',
            'title'    => esc_html__( 'Banner Background Type', 'yog-core' ),
            'subtitle' => esc_html__( 'Select this option for Background Type color or image and video.', 'yog-core' ),
            'options'  => array(
                'color' => 'Color',
                'image' => 'Image',
                
            ),
            'default'  => 'color',
            'required'  => array( 'enable_banner', '=', 'yes' ),
        ),

        array(
            'id'       => 'banner_image',         
            'type'     => 'media',
            'url'      => false,
            'title'    => esc_html__( 'Banner Background Image','yog-core'),
            'read-only'=> false,
            'required'  => array( 'banner_back_type', '=', 'image' ),
            'subtitle' => esc_html__( 'Upload Image for your body.','yog-core'),
            
            
        ), 

        array(
            'id'            => 'banner_back_color',
            'type'          => 'color',
            'title'         => esc_html__( 'Set Background Color', 'yog-core' ),
            'subtitle'      => esc_html__( 'Choose Background Color', 'yog-core' ),
            'required'  => array( 'banner_back_type', '=', 'color' ),
            'mode'          => 'background',
            'transparent'   => false,
           
        ),        

    )
)); 
?>