<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

/**
 * Elementor Blog widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */

class woo_Pt_PRoduct_Grid extends Widget_Base {
	
	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */

	public function get_name() {
		return __( 'woo_ft_Product_grid', 'hostingo' );
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve heading widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	
	public function get_title() {
		return __( 'Woccommerece Product Grid', 'hostingo' );
	}

	/**
	 * Get widget categories.
	 *
	 * Retrieve the list of categories the heading widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * @since 2.0.0
	 * @access public
	 *
	 * @return array Widget categories.
	 */

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */

	public function get_icon() {
		return 'eicon-slider-push';
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */

	protected function _register_controls() {
		$this->start_controls_section(
			'section_blog',
			[
				'label' => __( 'Product Grid', 'hostingo' ),
				
			]
		);

		$this->add_control(
			'pt_product_type',
			[
				'label'      => __( 'Select Product', 'hostingo' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'products',
				'options'    => [
					
					'featured_products' => __( 'Feature Product', 'hostingo' ),
					'recent_products' => __( 'Recent Product', 'hostingo' ),
					'sale_products'   => __( 'Sale Product', 'hostingo' ),
					'best_selling_products' => __( 'Best Selling Product', 'hostingo' ),
					'top_rated_products'    => __( 'Top Rated Product', 'hostingo' ),
					'products'          => __( 'All Products', 'hostingo' ),
				],
			]
		);

        $this->add_control(
			'pt_woo_column',
			[
				'label'      => __( 'Column', 'hostingo' ),
				'type'       => Controls_Manager::SELECT,
				
				'options'    => [
					'1'          => __( '1 Columns', 'hostingo' ),
					'2'          => __( '2 Columns', 'hostingo' ),
					'3'          => __( '3 Columns', 'hostingo' ),
					'4'          => __( '4 Columns', 'hostingo' ),
					'5'          => __( '5 Columns', 'hostingo' ),
					'6'          => __( '6 Columns', 'hostingo' ),
				],
				'default'    => '1',
			]
		);

		$this->add_control(
			'pt_pt_woo_order_by',
			[
				'label'   => __( 'Order By', 'hostingo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'rand',
				'options' => [
						'none' => esc_html__('None', 'hostingo'), 
						'rand' => esc_html__('Random', 'hostingo'), 
						'date' => esc_html__('Date', 'hostingo'), 
						'menu_order' => esc_html__('Menu Order', 'hostingo'), 
						'popularity' => esc_html__('Popularity', 'hostingo'), 
						'rating' => esc_html__('Rating', 'hostingo'), 
						'title' => esc_html__('Title', 'hostingo'), 
				],

			]
		);

		$this->add_control(
			'pt_woo_order',
			[
				'label'   => __( 'Order', 'hostingo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'ASC',
				'options' => [
						'DESC' => esc_html__('Descending', 'hostingo'), 
						'ASC' => esc_html__('Ascending', 'hostingo') 
				],

			]
		);

		$this->add_control(
			'pt_woo_per_page',
			[
				'label' => __( 'Per Page', 'hostingo' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,
				
				'step' => 1,
				'default' => 10,
			]
		);
		$this->add_control(
			'pt_show_pagination',
			[
				'label' => __( 'Show Pagination', 'hostingo' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'hostingo' ),
				'label_off' => __( 'Hide', 'hostingo' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$array = [];		
		$categories = pt_woo_get_category();
		if ( ! empty( $categories ) ) {
  			foreach ( $categories as $cat ) {
    			$array[$cat->slug] = $cat->slug;		
  			}
		}
		
		
		$this->add_control(
			'pt_woo_category',
			[
				'label' => __( 'Display Product From Specific Categoy', 'hostingo' ),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => $array,
				
			]
		);

		$this->add_control(
			'pt_cat_operator',
			[
				'label'   => __( 'Categoy Operator', 'hostingo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'IN',
				'options' => [
						'AND' => esc_html__('AND', 'hostingo'), 
						'IN' => esc_html__('IN', 'hostingo'), 
						'NOT IN' => esc_html__('NOT IN', 'hostingo'), 
				],

			]
		);

		$this->add_control(
			'pt_woo_tag',
			[
				'label' => __( 'Display Product From Specific Tag', 'hostingo' ),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'multiple' => true,
				'options' => pt_woo_product_tags(),
				
			]
		);

		$this->add_control(
			'pt_tag_operator',
			[
				'label'   => __( 'Tag Operator', 'hostingo' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'IN',
				'options' => [
						'AND' => esc_html__('AND', 'hostingo'), 
						'IN' => esc_html__('IN', 'hostingo'), 
						'NOT IN' => esc_html__('NOT IN', 'hostingo'), 
				],

			]
		);

		// $this->add_control(
		// 	'important_note',
		// 	[
		// 		'label' => __( 'Important Note', 'plugin-name' ),
		// 		'type' => \Elementor\Controls_Manager::RAW_HTML,
		// 		'raw' => __( '
  // 					<ul><li><code>AND</code> &ndash; Will display products that belong in all of the chosen categories.</li><li><code>IN</code> &ndash; Will display products within the chosen category. This is the default <code>cat_operator</code> value.</li><li><code>NOT IN</code> &ndash; Will display products that are not in the chosen category.</li></ul>', 'plugin-name' ),
		// 		'content_classes' => 'pt-info-class',
		// 	]
		// );

		
        $this->end_controls_section();
	}
	/**
	 * Render Blog widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	
	protected function render() {
		
		require  YOG_PLUGIN_DIR . '/includes/elementor/woo/render/product.php';
		
		if ( Plugin::$instance->editor->is_edit_mode() ) :
			
		?>
		<?php endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\woo_Pt_PRoduct_Grid() );
