<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 
class Timeline extends Widget_Base {
  public function get_name() {
    return __( 'Timeline', 'yog-core' );
  }
  
  public function get_title() {
    return __( 'Timeline', 'yog-core' );
  }
  public function get_categories() {
    return [ 'yog-core' ];
    }
  public function get_icon() {
    return 'eicon-carousel';
  }
  protected function _register_controls() {
    $this->start_controls_section(
      'section_Timeline',
      [
        'label' => __( 'Timeline', 'yog-core' ),
      ]
    );
    $repeater = new Repeater();
       $repeater->add_control(
      'title_text',
      [
        'label' => __( 'Title & Description', 'yog-core' ),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'This is Title', 'yog-core' ),
        'placeholder' => __( 'Enter your title', 'yog-core' ),
        'label_block' => true,
      ]
    );
    $repeater->add_control(
      'description_text',
      [
        'label' => __( 'Content', 'yog-core' ),
        'type' => Controls_Manager::WYSIWYG,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( 'Enter Your Subtitle Here.', 'yog-core' ),
        'placeholder' => __( 'Enter your description', 'yog-core' ),
        'separator' => 'none',
        'rows' => 10,
        'show_label' => false,
      ]
    );
        
        $this->add_control(
      'list',
      [
        'label' => __( 'List', 'yog-core' ),
        'type' => Controls_Manager::REPEATER,
        'fields' => $repeater->get_controls(),
        'default' => [
          [
            'list_item' => __( 'List 1', 'yog-core' ),
            
          ]
          
        ]
      ]
    ); 
        $this->add_control(
      'desk_num',
      [
        'label' => __( 'desktop', 'yog-core' ),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
          'active' => true,
        ],
        'default' => __( '4', 'yog-core' ),
      ]
    );
     $this->add_control(
      'VerticalMode',
      [
        'label' => __( 'forceVerticalMode', 'yog-core' ),
        'type' => Controls_Manager::TEXT,
        'dynamic' => [
          'active' => true,
        ],
      ]
    );

        
        $this->end_controls_section();
  }
  
  protected function render() {
    $settings = $this->get_settings();
    require YOG_PLUGIN_DIR . '/includes/elementor/render/Timeline.php';
     
    
    }     
    
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Timeline() );