<?php

namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_testi extends Widget_Base {

	public function get_name() {

		return __( 'testimonial', 'yog-core' );

	}

	

	public function get_title() {

		return __( 'Testimonial', 'yog-core' );

	}

	public function get_categories() {

		return [ 'yog-core' ];

    }

    

	/**

	 * Get widget icon.

	 *

	 * Retrieve counter widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-testimonial-carousel';

	}

	protected function _register_controls() {

		$this->start_controls_section(

			'section',

			[

				'label' => __( 'Style', 'yog-core' ),

			]

		);

		// $this->add_control(

  //           'testimonial_style',

  //           [

                

  //               'type' => 'image_select_control',

  //               'option' => [

  //               				'1' => YOG_PLUGIN_URL.'/assests/img/testimonial/1.png', 

  //               				'2' => YOG_PLUGIN_URL.'/assests/img/testimonial/12.png',

  //               				'3' => YOG_PLUGIN_URL.'/assests/img/testimonial/1.png', 

  //               				'4' => YOG_PLUGIN_URL.'/assests/img/testimonial/1.png', 

  //               				'5' => YOG_PLUGIN_URL.'/assests/img/testimonial/1.png', 

                				

  //               			],

  //               'description' => __('This is description' , 'yog-core')

  //           ]

  //       );



        $this->add_control(

			'testimonial_style',

			[

				'label' => __( 'Select Style', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'default' => '1',

				'options' => [

					'1'  => __( 'Style 1', 'plugin-domain' ),

					 '2' => __( 'Style 2', 'plugin-domain' ),

					 '3' => __( 'Style 3', 'plugin-domain' ),

					// '4' => __( 'Style 4', 'plugin-domain' ),

					// '5' => __( 'Style 5', 'plugin-domain' ),

					// '6' => __( 'Style 6', 'plugin-domain' ),

				],

			]

		);

        $this->end_controls_section();

		$this->start_controls_section(

			'section_slider',

			[

				'label' => __( 'Testimonial', 'yog-core' ),

			]

		);

		$repeater = new Repeater();

		$repeater->add_control(

			'image',

			[

				'label' => __( 'Choose Image', 'yog-core'),

				'type' => Controls_Manager::MEDIA,

				'dynamic' => [

					'active' => true,

				],

				

				// 'condition' => [

				// 	'image_style' => '1',

				// ],

			]

		);

		$repeater->add_control(

			'title_text',

			[

				'label' => __( 'client name', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );

       

		$repeater->add_control(

			'desg_text',

			[

				'label' => __( 'designation', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sub sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );

        $repeater->add_control(

			'star_num',

			[

				'label' => __( 'ratings', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'options' => [

					'1'  => '1 star',

					'2'  => '2 star',

					'3'  => '3 star',

					'4'  => '4 star',

					'5'  => '5 star',

				],

				

			]

			

		);

       

		$repeater->add_control(

			'description_text',

			[

				'label' => __( 'Content', 'yog-core' ),

				'type' => Controls_Manager::WYSIWYG,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'Enter your Description here', 'yog-core' ),

				'placeholder' => __( 'Enter your description', 'yog-core' ),

				'separator' => 'before',

				'rows' => 10,

				'show_label' => true,

			]

		);

		$this->add_control(

			'tabs',

			[

				'label' => __( 'Tabs Items', 'yog-core' ),

				'type' => Controls_Manager::REPEATER,

				'fields' => $repeater->get_controls(),

				'default' => [

					[

						'title_text' => __( 'Service Box', 'yog-core' ),

						

						

					]

				]

			]

		);

		

		

        $this->end_controls_section();



        $this->start_controls_section(

			'section__2p08cZ',

			[

				'label' => __( 'Alignment', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

		 $this->add_responsive_control(

			'content_align',

			[

				'label' => __( 'Alignment', 'yog-core' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'text-left' => [

						'title' => __( 'Left', 'yog-core' ),

						'icon' => 'eicon-text-align-left',

					],

					'text-center' => [

						'title' => __( 'Center', 'yog-core' ),

						'icon' => 'eicon-text-align-center',

					],

					'text-right' => [

						'title' => __( 'Right', 'yog-core' ),

						'icon' => 'eicon-text-align-right',

					],

					

				],

				

			]

		);

		$this->end_controls_section();



       $this->start_controls_section(

			'section__2p08cZ1',

			[

				'label' => __( 'Colors', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

       $this->add_control(

			'bg_color',

			[

				'label' => __( 'Background Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-testimonial-box' => 'background-color: {{VALUE}};',

		 		],

			]

		);

		$this->add_control(

			'member_name_color',

			[

				'label' => __( 'Name Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-testimonial-meta h5' => 'color: {{VALUE}};',

					'{{WRAPPER}} .gt-testimonial-info h5' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

		$this->add_control(

			'Designation_colors',

			[

				'label' => __( 'Designation Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-testimonial-info span' => 'color: {{VALUE}};',

					'{{WRAPPER}} .gt-testimonial-meta p' => 'color: {{VALUE}};',

					



		 		],

				

				

			]

		);

        

        $this->add_control(

			'desc_color',

			[

				'label' => __( 'Description', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-testimonial-content p' => 'color: {{VALUE}};',
					'{{WRAPPER}}  .gt-testimonial-info p' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);


		
       $this->add_control(

			'circle_border',

			[

				'label' => __( 'Circle Border Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-testimonialbox-style-3 .gt-testimonial-media' => 'border-color: {{VALUE}};'

		 		],

				

				

			]

		);


		$this->add_control(

			'star',

			[

				'label' => __( 'Stars Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} i.fa.fa-star' => 'color: {{VALUE}};'

		 		],

				

				

			]

		);


		

		$this->add_control(

			'overlay_color',

			[

				'label' => __( 'Overlay Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-quote i' => 'color: {{VALUE}};',

					'{{WRAPPER}} .gt-testmonial-style-2 .gt-quote i' => 'opacity: {{VALUE}};',

		 		],

				

				

			]

		);

		$this->add_control(

			'Overlay Opacity',

			[

				'label' => __( 'Overlay Opacity', 'plugin-domain' ),

				'type' => Controls_Manager::NUMBER,

				'min' => 0,

				'max' => 1,

				'default' => '0.05',

				'selectors' => [

					'{{WRAPPER}} .gt-quote i' => 'opacity: {{VALUE}};',

					'{{WRAPPER}} .gt-testmonial-style-2 .gt-quote i' => 'opacity: {{VALUE}};',





					

		 		],

				

				

			]

		);

		 $this->end_controls_section();



		  $this->start_controls_section(

			'section__2p08Z1',

			[

				'label' => __( 'Typography', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



		 $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'member_name_typography',

				'label' => __( 'Name', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-testimonial-info h5',

				              '{{WRAPPER}} .gt-testimonial-meta h5',

			]

		);



		 $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'Designation_typography',

				'label' => __( 'Designation', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-testimonial-info span',

				              '{{WRAPPER}} .gt-testimonial-meta span',

			]

				 

		);



		 $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'descrition_typography',

				'label' => __( 'Description', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-testimonial-content p',

			]

		);



		  $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'star_typography',

				'label' => __( 'Stars', 'yog-core' ),				

				'selector' => '{{WRAPPER}} i.fa.fa-star',

			]

		);



		   $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'overlay_typography',

				'label' => __( 'Overlay Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} i.fa.fa-quote-left' ,

			]

		);



		 $this->end_controls_section();



		 $this->start_controls_section(

			'section_slider_control',

			[

				'label' => __( 'Slider Control', 'interior-core' ),

			]

		);

		require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-control.php';



		$this->end_controls_section();



	}

	

	

	protected function render() {

		$settings = $this->get_settings();

         require YOG_PLUGIN_DIR . '/includes/elementor/render/testimonial.php' ;



          if ( Plugin::$instance->editor->is_edit_mode() ) :

         	require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-common-js.php';

         endif; 



    }	    

		

}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_testi() );