<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;

class teams extends Widget_Base {

	public function get_name() {
		return __( 'team', 'yog-core' );
	}

	public function get_title() {
		return __( 'Team', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }


	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-lock-user';
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'fancy_style',
            [

                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/team/1.png',

                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'Team', 'yog-core' ),
			]
		);

        $this->add_control(
            'desk_num',
            [
                'label' => __( 'Desktop number', 'yog-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '3', 'yog-core' ),
                'separator' => 'before',

            ]
        );
        $this->add_control(
            'lap_num',
            [
                'label' => __( 'Laptop number', 'yog-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '3', 'yog-core' ),
                'separator' => 'before',

            ]
        );

        $this->add_control(
            'tab_num',
            [
                'label' => __( 'Tablet number', 'yog-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '2', 'yog-core' ),
                'separator' => 'before',

            ]
        );

        $this->add_control(
            'mob_num',
            [
                'label' => __( 'Mobile number', 'yog-core' ),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => __( '1', 'yog-core' ),
                'separator' => 'before',

            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'      => __( 'Autoplay', 'yog-core' ),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'true',
                'options'    => [
                    'true'       => __( 'True', 'yog-core' ),
                    'False'          => __( 'False', 'yog-core' ),

                ],

            ]
        );
        $this->add_control(
            'loop',
            [
                'label'      => __( 'Loop', 'yog-core' ),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'true',
                'options'    => [
                    'true'       => __( 'True', 'yog-core' ),
                    'False'          => __( 'False', 'yog-core' ),

                ],

            ]
        );

        $this->add_control(
            'nav_arrow',
            [
                'label'      => __( 'Navigation Arrow', 'yog-core' ),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'true',
                'options'    => [
                    'true'       => __( 'True', 'yog-core' ),
                    'false'          => __( 'False', 'yog-core' ),

                ],

            ]
        );
        $this->add_control(
            'dots',
            [
                'label'      => __( 'Dots', 'yog-core' ),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'true',
                'options'    => [
                    'true'       => __( 'True', 'yog-core' ),
                    'false'          => __( 'False', 'yog-core' ),

                ],

            ]
        );

        $this->add_responsive_control(
            'margin',
            [
                'label' => __( 'Space', 'elementor' ),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 30,
                ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],


            ]
        );



		$this->end_controls_section();

        /**
         * Style Tab: Name
         */
        $this->start_controls_section(
            'section_name_style_0tQA3CzUUR',
            [
                'label' => __('Name', 'yog-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'btn_text_color_tabs' );

		$this->start_controls_tab(
			'tabs_0tQA3CzUUR',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'member_name_typography_0tQA3CzUUR',
                'label' => __('Typography', 'yog-core'),

                'selector' => '{{WRAPPER}} a.gt-member-name',
            ]
        );

        $this->add_control(
            'text_color_0tQA3CzUUR',
            [
                'label' => __('Color', 'yog-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} a.gt-member-name' => 'color: {{VALUE}}',
                ],
            ]
        );


        $this->end_controls_tab();

    	$this->end_controls_tabs();




        $this->end_controls_section();

        /**
         * Style Tab: Description
         */

        /**
         * Style Tab: Icon
         */
        $this->start_controls_section(
            'section_member_icon_style',
            [
                'label' => __('Icon', 'yog-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );



        $this->start_controls_tabs( 'btn_text_color_tabs_6uQCNFWWE1' );

		$this->start_controls_tab(
			'tabs_6uQCNFWWE1',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

         $this->add_responsive_control(
			'font_size_6uQCNFWWE1',
			[
				'label' => __( 'Icon Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],

				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],

				'selectors' => [
					'{{WRAPPER}} .gt-team-box .gt-team-social ul li a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
            'text_color_6uQCNFWWE1',
            [
                'label' => __('Color', 'yog-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .gt-team-box .gt-team-social ul li a i' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();


        $this->start_controls_tab(
            'tabs_BDwoWLUoMC',
            [
                'label' => __( 'Hover', 'repairer-core' ),
            ]
        );
         $this->add_responsive_control(
            'font_size_BDwoWLUoMC',
            [
                'label' => __( 'Icon Size', 'plugin-domain' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],

                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],

                'selectors' => [
                    '{{WRAPPER}} ..gt-team-box .gt-team-social ul li a i:hover' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'text_color_BDwoWLUoMC',
            [
                'label' => __('Color', 'repairer-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .gt-team-box .gt-team-social ul li a i:hover' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_tab();


    	$this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * Style Tab: Designation
         */
        $this->start_controls_section(
            'section_member_description_style',
            [
                'label' => __('Designation', 'yog-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );



        $this->start_controls_tabs( 'btn_text_color_tabs_JE1cnDXe30' );

		$this->start_controls_tab(
			'tabs_JE1cnDXe30',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'member_name_typography_JE1cnDXe30',
                'label' => __('Typography', 'yog-core'),

                'selector' => '{{WRAPPER}} span.gt-team-designation',
            ]
        );

        $this->add_control(
            'text_color_JE1cnDXe30',
            [
                'label' => __('Color', 'yog-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} span.gt-team-designation' => 'color: {{VALUE}}',

                ],
            ]
        );

        $this->end_controls_tab();

    	$this->end_controls_tabs();
        $this->end_controls_section();


		 $this->start_controls_section(
			'section__2p08cZ22',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		 $this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],

				],

			]
		);
		$this->end_controls_section();

	}

	protected function render() {
		$settings = $this->get_settings();
        require_once YOG_PLUGIN_DIR . '/includes/elementor/render/team.php';
        if ( Plugin::$instance->editor->is_edit_mode() ) :
          require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-common-js.php';
      endif;
  }

}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\teams() );