<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed INDUSTRIE_PLUGIN_DIRectly.
}

class Tabs extends Widget_Base {

	public function get_name() {
		return __( 'tabs', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Tabs', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	
	public function get_icon() {
		return 'eicon-tabs';
	}

	
	protected function _register_controls() {
		$this->start_controls_section(
			'section_tabs',
			[
				'label' => __( 'Tabs', 'yog-core' ),
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Title & Description', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Tab Title', 'yog-core' ),
				'placeholder' => __( 'Tab Title', 'yog-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'INDUSTRIE_PLUGIN_URL' => Utils::get_placeholder_image_src(),
				]
			]
		);

		$repeater->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
		);
		
		$repeater->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Description here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
        );

        $repeater->add_control(
			'list',
			[
				'label' => __( 'Lists', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				
				'placeholder' => __( 'Put Html Code Here', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
        );

         $repeater->add_control(
			'tab_btn_link',
			[
				'label' => __( 'Link', 'seozie-core' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'seozie-core' ),
				'separator' => 'before',
			]
		);	

		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Tab #1', 'yog-core' ),
						'image' => Utils::get_placeholder_image_src(),
						'title_text' => __( 'Title', 'yog-core' ),
						'description_text' => __( 'Description', 'yog-core' ),
						
					]
				]
			]
		);

		

		

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);

		

		$this->end_controls_section();

		$this->start_controls_section(
			'section_Jnza43wt8d9QH5b77duo',
			[
				'label' => __( 'Button', 'yog-core' ),
			]
		);
			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';

		// $this->end_controls_section();
	}

	/**
	 * Render tabs widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
        //$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/tabs.php' ;
		
    }
    
   

	
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Tabs() );
