<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class table extends Widget_Base {

	public function get_name() {
		return __( 'table', 'gymster-core' );
	}
	
	public function get_title() {
		return __( ' table', 'gymster-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-button';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_Jnza43wt8d9QH5b77duo',
			[
				'label' => __( 'table', 'gymster-core' ),
			]
		);

		
		$this->add_control(
			'views',
			[
				'label' => __( 'Border Style', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'dropdown_list'  => __( 'dropdown_list', 'plugin-domain' ),
					'tabs' => __( 'tabs', 'plugin-domain' ),
					
				],
			]
		);
		$this->add_control(
			'show_title',
			[
				'label' => __( 'Show  Title', 'gymster-core' ),
				'type' => Controls_Manager::SWITCHER,
				'1' => __( 'Show', 'gymster-core' ),
				'0' => __( 'Hide', 'gymster-core' ),
				
			]
		);
		$this->add_control(
			'show_sub_title',
			[
				'label' => __( 'Show sub Title', 'gymster-core' ),
				'type' => Controls_Manager::SWITCHER,
				'1' => __( 'Show', 'gymster-core' ),
				'0' => __( 'Hide', 'gymster-core' ),
				
			]
		);
		$this->add_control(
			'show_desc',
			[
				'label' => __( 'Show description', 'gymster-core' ),
				'type' => Controls_Manager::SWITCHER,
				'1' => __( 'Show', 'gymster-core' ),
				'0' => __( 'Hide', 'gymster-core' ),
				'0' => 'hide',
			]
		);
		$this->add_control(
			'show_time',
			[
				'label' => __( 'Show time', 'gymster-core' ),
				'type' => Controls_Manager::SWITCHER,
				'1' => __( 'Show', 'gymster-core' ),
				'0' => __( 'Hide', 'gymster-core' ),
				'0' => 'hide',
			]
		);
		$this->add_control(
			'show_responsive',
			[
				'label' => __( 'Show responsive', 'gymster-core' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'gymster-core' ),
				'label_off' => __( 'Hide', 'gymster-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/table.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\table() );