<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
class Pt_Subscribe extends Widget_Base {
	public function get_name() {
		return __( 'Pt_Subscribe', 'yog-core' );
	}

	public function get_title() {
		return __( 'Mailchimp Subscribe', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
	}
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-info-box';
	}
	protected function _register_controls() {

		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Subscribe Box', 'yog-core' ),
			]
		);
		$this->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'1'          => __( 'Image', 'yog-core' ),
					'2'          => __( 'Icon', 'yog-core' ),

				],
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],

				'condition' => [
					'image_style' => '1',
				],
			]
		);
		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'fas fa-check',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => '2',
				]
			]
		);


		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sub sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );



		$this->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Description here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .pt-subscribe' => 'text-align: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();


		 $this->start_controls_section(
			'section_a84320g2u',
			[
				'label' => __( 'Background', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
         $this->start_controls_tabs( 'tabs_2a023sGfU' );
         $this->start_controls_tab(
            'tabs_tJ74N2F',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );
         $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background_WA2eRT534bw2a',
                'label' => __( 'Background', 'yog-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .pt-subscribe ',
            ]
        );

         $this->end_controls_tab();
         $this->start_controls_tab(
            'tabs__Ax45FF0ea',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
         $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background__o5PRTa8H8',
                'label' => __( 'Background', 'yog-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .pt-subscribe .pt-sub-media i:hover',
            ]
        );
         $this->end_controls_tabs();
		 $this->end_controls_section();

		  $this->start_controls_section(
			'section_a820g2u',
			[
				'label' => __( 'Icon Box', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
         $this->start_controls_tabs( 'tabs_2a0sGfU' );
         $this->start_controls_tab(
            'tabs_tJ74N652F',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );

         $this->add_control(
			'color__BbYaUJF3',
			[
				'label' => __( 'Icon Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pt-sub-media i' => 'color: {{VALUE}};',
		 		],


			]
		);
         $this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 14,
				],
				'range' => [
					'px' => [
						'min' => 6,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .pt-sub-media i' => 'font-size: {{SIZE}}{{UNIT}};',

				],
			]
		);






         $this->end_controls_tab();



		 $this->end_controls_section();

		 // Title Style
		 $this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_kpscb63',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .pt-subscribe .pt-subscribe-title',
			]
		);
 		$this->add_control(
			'title_color__BbYUJF3',
			[
				'label' => __( 'TItle Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pt-subscribe .pt-subscribe-title' => 'color: {{VALUE}};',
		 		],


			]
		);







		// Spacing




         $this->end_controls_section();

         // sub titile

         $this->start_controls_section(
			'section__74ile76',
			[
				'label' => __( 'Description', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__74ile7s6',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .pt-subscribe .pt-subscribe-desc',
			]
		);
           $this->add_control(
			'color__74iled76',
			[
				'label' => __( 'Text Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .pt-subscribe .pt-subscribe-desc' => 'color: {{VALUE}};',
		 		],


			]
		);








		$this->end_controls_tab();
         $this->end_controls_tabs();
		 $this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();

		require YOG_PLUGIN_DIR . '/includes/elementor/render/subscribe.php';

    }

}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Pt_Subscribe() );