<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class slider extends Widget_Base {

	public function get_name() {
		return __( 'slider', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'gym Slider', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }
    

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-carousel';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'gym Slider', 'yog-core' ),
			]
		);

		

		$this->add_control(
			'carousel',
			[
				'label' => __( 'Add Images', 'yog-core' ),
				'type' => Controls_Manager::GALLERY,
				'default' => [],
				'show_label' => false,
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', 
				'default' => 'full',
				'separator' => 'none'				
			]
			
		);    
        
        $this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/slider.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\slider() );