<?php

namespace Elementor; 

if ( ! defined( 'ABSPATH' ) ) exit; 



class yog_Service_Boxes extends Widget_Base {



	public function get_name() {

		return __( 'yog_Service_Box', 'yog-core' );

	}

	

	public function get_title() {

		return __( 'Service-Box', 'yog-core' );

	}



	public function get_categories() {

		return [ 'yog-core' ];

	}



	/**

	 * Get widget icon.

	 *

	 * Retrieve counter widget icon.

	 *

	 * @since 1.0.0

	 * @access public

	 *

	 * @return string Widget icon.

	 */

	public function get_icon() {

		return 'eicon-info-box';

	}



	protected function _register_controls() {

		

		$this->start_controls_section(

			'section',

			[

				'label' => __( 'Style', 'yog-core' ),

			]

		);



		$this->add_control(

            'service_style',

            [

                

                'type' => 'image_select_control',

                'option' => [

                				'1' => YOG_PLUGIN_URL.'/assests/img/service/1.png', 

                				'2' => YOG_PLUGIN_URL.'/assests/img/service/1.png', 

                				'3' => YOG_PLUGIN_URL.'/assests/img/service/1.png',

                				'4' => YOG_PLUGIN_URL.'/assests/img/service/1.png',  

                				 

                				

                			],

                'description' => __('This is description' , 'yog-core')

            ]

        );



        $this->end_controls_section();

		$this->start_controls_section(

			'section_image',

			[

				'label' => __( 'ServiceBox', 'yog-core' ),

			]

		);



		$this->add_control(

			'banner_image',

			[

				'label' => __( 'Banner Image', 'yog-core'),

				'type' => Controls_Manager::MEDIA,

				'dynamic' => [

					'active' => true,

				],

				

				

			]

		);



		$this->add_control(

			'image_style',

			[

				'label'      => __( 'Choose Image/Icon', 'yog-core' ),

				'type'       => Controls_Manager::SELECT,

				'default'    => 'none',

				'options'    => [

					'none'       => __( 'None', 'yog-core' ),

					'1'          => __( 'Image', 'yog-core' ),

					'2'          => __( 'Icon', 'yog-core' ),

					

				],

				

			]

		);



		



		$this->add_control(

			'image',

			[

				'label' => __( 'Choose Image', 'yog-core'),

				'type' => Controls_Manager::MEDIA,

				'dynamic' => [

					'active' => true,

				],

				

				'condition' => [

					'image_style' => '1',

				],

			]

		);



		

		



		$this->add_control(

			'selected_icon',

			[

				'label' => __( 'Icon', 'yog-core' ),

				'type' => Controls_Manager::ICONS,

				'label_block' => true,

				'default' => [

					'value' => 'ion ion-android-arrow-dropright',

					'library' => 'fa-solid',

				],

                'fa4compatibility' => 'icon',

				'separator' => 'before',

				'condition' => [

					'image_style' => '2',

				]

			]

		);


 
        $this->add_control(
			'price',
			[
				'label' => __( 'Price', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'Price', 'yog-core' ),
				
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$this->add_control(
			'star',
			[
				'label' => __( 'Star', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'default' => '5',
				'options' => [
					'1'  => '1',
					'2'  => '2',
					'3'  => '3',
					'4'  => '4',
					'5'  => '5'
				],
				
			]
			
		);

		



		$this->add_control(

			'title_text',

			[

				'label' => __( 'Title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your title', 'yog-core' ),

				'label_block' => true,

			]

        );

        $this->add_control(

			'subtitle_text',

			[

				'label' => __( 'Sub Title', 'yog-core' ),

				'type' => Controls_Manager::TEXT,

				'dynamic' => [

					'active' => true,

				],

				'default' => __( 'This is sub sample title', 'yog-core' ),

				'placeholder' => __( 'Enter your sub title', 'yog-core' ),

				'label_block' => true,

			]

        );

        $repeater = new Repeater();

        $repeater->add_control(

			'select_icon',

			[

				'label' => __( 'Icon', 'yog-core' ),

				'type' => Controls_Manager::ICONS,

				'label_block' => true,

				'default' => [

					'value' => 'ion ion-android-arrow-dropright',

					'library' => 'fa-solid',

				],

                'fa4compatibility' => 'icon',

				'separator' => 'before',


			]

		);

        $repeater->add_control(
			'list_title',
			[
				'label' => __( 'List Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'List Title', 'yog-core' ),
				
				'dynamic' => [
					'active' => true,
				],
			]
		);


		 $this->add_control(
			'list',
			[
				'label' => __( 'List', 'seozie-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_item' => __( 'List 1', 'yog-core' ),
						
					]
					
				]
			]
		);
		 



        $this->add_control(

			'title_tag',

			[

				'label' => __( 'Title Tag', 'plugin-domain' ),

				'type' => Controls_Manager::SELECT,

				'default' => 'h5',

				'options' => [

					'h1'  => 'h1',

					'h2'  => 'h2',

					'h3'  => 'h3',

					'h4'  => 'h4',

					'h5'  => 'h5',

					'h6'  => 'h6',

					'p'  => 'p',

					'span'  => 'span',

					

				],

				

			]

			

		);





		// $this->add_control(

		// 	'description_text',

		// 	[

		// 		'label' => __( 'Content', 'yog-core' ),

		// 		'type' => Controls_Manager::WYSIWYG,

		// 		'dynamic' => [

		// 			'active' => true,

		// 		],

		// 		'default' => __( 'Enter your Description here', 'yog-core' ),

		// 		'placeholder' => __( 'Enter your description', 'yog-core' ),

		// 		'separator' => 'before',

		// 		'rows' => 10,

		// 		'show_label' => true,

		// 		'condition' => [

		// 			'service_style' => '1',

		// 		],

		// 	]

		// );





		// $this->add_control(

		// 	'description_text',

		// 	[

		// 		'label' => __( 'Content', 'yog-core' ),

		// 		'type' => Controls_Manager::WYSIWYG,

		// 		'dynamic' => [

		// 			'active' => true,

		// 		],

		// 		'default' => __( 'Enter your Description here', 'yog-core' ),

		// 		'placeholder' => __( 'Enter your description', 'yog-core' ),

		// 		'separator' => 'before',

		// 		'rows' => 10,

		// 		'show_label' => true,

		// 		'condition' => [

		// 			'service_style' => '2',

		// 		],

		// 	]

		// );

		$this->add_responsive_control(

			'text_align',

			[

				'label' => __( 'Alignment', 'yog-core' ),

				'type' => Controls_Manager::CHOOSE,

				'options' => [

					'left' => [

						'title' => __( 'Left', 'yog-core' ),

						'icon' => 'eicon-text-align-left',

					],

					'center' => [

						'title' => __( 'Center', 'yog-core' ),

						'icon' => 'eicon-text-align-center',

					],

					'right' => [

						'title' => __( 'Right', 'yog-core' ),

						'icon' => 'eicon-text-align-right',

					]

				],

				'selectors' => [

					'{{WRAPPER}} .gt-service-box' => 'text-align: {{VALUE}}',

				],

			]

		);


        $this->add_control(
			'show_button',
			[
				'label' => __( 'Show/Hide button', 'interior-core' ),
				'type' => Controls_Manager::SWITCHER,
				'yes' => __( 'yes', 'interior-core' ),
				'no' => __( 'no', 'interior-core' ),
			]
        );

		$this->end_controls_section();


		

		$this->start_controls_section(

			'section_Jnza43wt8d9QH5b77duo',

			[

				'label' => __( 'Button', 'yog-core' ),

			]

		);

			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';



		//$this->end_controls_section();



		



		$this->start_controls_section(

			'section__2p08cZ1',

			[

				'label' => __( 'Title', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);



         $this->start_controls_tabs( 'tabs__WZbRxd5' );

         $this->start_controls_tab(

            'tabs_eCc902a',

            [

                'label' => __( 'Normal', 'elementor' ),

            ]

        );



         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography_kpscb63',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-service-box .gt-service-title',

			]

		);



 		$this->add_control(

			'title_color__BbYUJF3',

			[

				'label' => __( 'TItle Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-service-box .gt-service-title' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);



		

		// Spacing



		

         $this->end_controls_tab();



         $this->start_controls_tab(

            'tabs_Ax450ea',

            [

                'label' => __( 'Hover', 'elementor' ),

            ]

        );

         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'title_typography_e38xupd',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-service-box .gt-service-title:hover',

			]

		);

		$this->add_control(

			'title_color_s3w1o04',

			[

				'label' => __( 'Hover Text Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-service-box .gt-service-title:hover' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

		

         $this->end_controls_tab();

         $this->end_controls_tabs();

         $this->end_controls_section();

         $this->start_controls_section(

			'section__74ile76',

			[

				'label' => __( 'Description', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

			]

		);

         $this->add_group_control(

			Group_Control_Typography::get_type(),

			[

				'name' => 'typography__74ile7s6',

				'label' => __( 'Typography', 'yog-core' ),				

				'selector' => '{{WRAPPER}} .gt-service-box .gt-service-description',

			]

		);

           $this->add_control(

			'color__74iled76',

			[

				'label' => __( 'Text Color', 'yog-core' ),

				

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-btn-container' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

           $this->add_control(

			'normal_text_color__95c04fg70',

			[

				'label' => __( 'Choose background Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-service-box-info' => 'background: {{VALUE}};',

		 		],

				

				

			]

		);

  		

		$this->end_controls_tab();

         $this->end_controls_tabs();        

		 $this->end_controls_section();



		 $this->start_controls_section(

			'section__005e759',

			[

				'label' => __( 'Icon', 'yog-core' ),

				'tab' => Controls_Manager::TAB_STYLE,

				

			]

		);

		$this->start_controls_tabs( 'tabs_section__005e759');



		$this->start_controls_tab(

			'tab_005e759',

			[

				'label' => __( 'Normal', 'yog-core' ),

			]

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			[

				'name' => 'btn_normal_data_background',

				'label' => __( 'Background', 'yog-core' ),

				'types' => [ 'classic', 'gradient' ],

				'selector' => '{{WRAPPER}} .gt-service-box .gt-service-media',

			]

		);

		

		$this->add_control(

			'normal_text_color__95c0470',

			[

				'label' => __( 'Choose Icon Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-service-box .gt-service-media i' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);



		 $this->add_responsive_control(

			'font_size_5128324387',

			[

				'label' => __( 'Icon Size', 'plugin-domain' ),

				'type' => Controls_Manager::SLIDER,

				'size_units' => [ 'px', '%' ],

				

				'range' => [

					'px' => [

						'min' => 0,

						'max' => 1000,

						'step' => 1,

					],

					'%' => [

						'min' => 0,

						'max' => 100,

					],

				],

				

				'selectors' => [

					'{{WRAPPER}} .gt-service-box .gt-service-media i' => 'font-size: {{SIZE}}{{UNIT}};',

				],

			]

		);



		$this->end_controls_tab();



		$this->start_controls_tab(

			'tab__95c0470',

			[

				'label' => __( 'Hover', 'yog-core' ),

			]

		);



		$this->add_group_control(

			Group_Control_Background::get_type(),

			[

				'name' => 'btn_hover_data_background',

				'label' => __( 'Background', 'yog-core' ),

				'types' => [ 'classic', 'gradient' ],

				'selector' => '{{WRAPPER}} .gt-service-box .gt-service-media:hover',

			]

		);

		$this->add_control(

			'hover_text_color_95c0470',

			[

				'label' => __( 'Choose Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,

				'selectors' => [

					'{{WRAPPER}} .gt-service-box .gt-service-media:hover' => 'color: {{VALUE}};',

		 		],

				

				

			]

		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();



	}

	

	protected function render() {

		$settings = $this->get_settings();

        require YOG_PLUGIN_DIR . '/includes/elementor/render/service-box.php';

    }	    

		

}



Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Service_Boxes() );