<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Service_Box_Slider extends Widget_Base {

	public function get_name() {
		return __( 'yog_Service_Box_Slider', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Service Box Slider', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-info-box';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'service_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/service/1.png', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Service Box', 'yog-core' ),
			]
		);

		$repeater = new Repeater();


		$repeater->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'1'          => __( 'Image', 'yog-core' ),
					'2'          => __( 'Icon', 'yog-core' ),
					
				],
			]
		);

		

		$repeater->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				'condition' => [
					'image_style' => '1',
				],
			]
		);

		
		

		$repeater->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => '2',
				]
			]
		);

		

		$repeater->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is  sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );


        $repeater->add_control(
			'subtitle_text',
			[
				'label' => __( 'Sub Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sub sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your sub title', 'yog-core' ),
				'label_block' => true,
			]
        );


        $repeater->add_control(
			'pricetitle',
			[
				'label' => __( 'Price Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is price', 'yog-core' ),
				'placeholder' => __( 'Enter your price', 'yog-core' ),
				'label_block' => true,
			]
        );

        $repeater->add_control(
			'title_tag',
			[
				'label' => __( 'Title Tag', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'h5',
				'options' => [
					'h1'  => 'h1',
					'h2'  => 'h2',
					'h3'  => 'h3',
					'h4'  => 'h4',
					'h5'  => 'h5',
					'h6'  => 'h6',
					'p'  => 'p',
					'span'  => 'span',
					
				],
				
			]
			
		);

      

       
		$repeater->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Description here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
		);


		$repeater->add_control(
			'button_text',
			[
				'label' => __( 'Button Text', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Click Here', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );
       

       $repeater->add_control(
			'btn_link',
			[
				'label' => __( 'Link', 'yog-core' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'yog-core' ),
				'separator' => 'before',
			]
		);	

		

        

		

		$this->add_control(
			'tabs',
			[
				'label' => __( 'Tabs Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'title_text' => __( 'Service Box', 'yog-core' ),
						
						
					]
				]
			]
		);


		
		$this->end_controls_section();


		 $this->start_controls_section(
			'section__2p08cZ',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		 $this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					
				],
				
			]
		);
		$this->end_controls_section();


		$this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Colors', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'subtitle_name_color',
			[
				'label' => __( 'Subtitle Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-sub-title' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->add_control(
			'title_colors',
			[
				'label' => __( 'Title Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h5.gt-service-title' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
        
        $this->add_control(
			'desc_color',
			[
				'label' => __( 'Description', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} p.gt-service-description' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'price_color',
			[
				'label' => __( 'Price', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-service-media span' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
        
       
		 


         $this->end_controls_section();


         $this->start_controls_section(
			'section__2p08yt1',
			[
				'label' => __( 'Typography', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		
		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'sub_name_typography',
				'label' => __( 'Sub Title', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-sub-title',
			]
		);

		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title', 'yog-core' ),				
				'selector' => '{{WRAPPER}} h5.gt-service-title',
			]
				 
		);

		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'descrition_typography',
				'label' => __( 'Description', 'yog-core' ),				
				'selector' => '{{WRAPPER}} p.gt-service-description',
			]
		);

		  $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Price', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-service-media span',
			]
		);
        $this->end_controls_section();


        $this->start_controls_section(
			'section_slider_control',
			[
				'label' => __( 'Slider Control', 'yog-core' ),
			]
		);
		require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-control.php';

		$this->end_controls_section();


        require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_slider_controls.php';

		
		
        
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/service-box-slider.php';
        if ( Plugin::$instance->editor->is_edit_mode() ) :
         	require YOG_PLUGIN_DIR . '/includes/elementor/common/slider-common-js.php';
         endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Service_Box_Slider() );