<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
class Sectiontitle extends Widget_Base {
	public function get_name() {
		return __( 'section_title', 'yog-core' );
	}

	public function get_title() {
		return __( 'Section Title', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
	}
/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-site-title';
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Section Title', 'yog-core' ),
			]
		);

  //       $this->add_control(
		// 	'show_title',
		// 	[
		// 		'label' => __( 'Show Title', 'yog-core' ),
		// 		'type' => Controls_Manager::SWITCHER,
		// 		'label_on' => __( 'Show', 'yog-core' ),
		// 		'label_off' => __( 'Hide', 'yog-core' ),
		// 		'return_value' => 'yes',
		// 		'default' => 'yes',
		// 	]
		// );

		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title & Description', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is Title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
				//'condition' => [ 'show_title' => 'yes']
			]
		);
		//  $this->add_control(
		// 	'title_tag',
		// 	[
		// 		'label' => __( 'Title Tag', 'plugin-domain' ),
		// 		'type' => Controls_Manager::SELECT,
		// 		'default' => 'h5',
		// 		'options' => [
		// 			'h1'  => 'h1',
		// 			'h2'  => 'h2',
		// 			'h3'  => 'h3',
		// 			'h4'  => 'h4',
		// 			'h5'  => 'h5',
		// 			'h6'  => 'h6',
		// 			'p'  => 'p',
		// 			'span'  => 'span',

		// 		],

		// 	]

		// );
  //     $this->add_control(
		// 	'show_sub_title',
		// 	[
		// 		'label' => __( 'Show Sub Title', 'yog-core' ),
		// 		'type' => Controls_Manager::SWITCHER,
		// 		'label_on' => __( 'Show', 'yog-core' ),
		// 		'label_off' => __( 'Hide', 'yog-core' ),
		// 		'return_value' => 'yes',
		// 		'default' => 'yes',
		// 	]
		// );
        $this->add_control(
			'sub_title_text',
			[
				'label' => __( 'Sub Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
				//'condition' => [ 'show_sub_title' => 'yes']
			]
        );
  //        $this->add_control(
		// 	'show_description',
		// 	[
		// 		'label' => __( 'Show Description', 'yog-core' ),
		// 		'type' => Controls_Manager::SWITCHER,
		// 		'label_on' => __( 'Show', 'yog-core' ),
		// 		'label_off' => __( 'Hide', 'yog-core' ),
		// 		'return_value' => 'yes',
		// 		'default' => 'yes',
		// 	]
		// );
		$this->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter Your Subtitle Here.', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'none',
				'rows' => 10,
				'show_label' => false,
				//'condition' => [ 'show_description' => 'yes']
			]
		);

		$this->end_controls_section();
		$this->start_controls_section(
			'section__2p08cZ',
			[
				'label' => __( 'Alignment', 'interior-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		 $this->add_responsive_control(
			'content_align',
			[
				'label' => __( 'Alignment', 'interior-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'interior-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'interior-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'interior-core' ),
						'icon' => 'eicon-text-align-right',
					],

				],

			]
		);
		$this->end_controls_section();


		 // Title Style
		 $this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

 		$this->add_control(
			'title_color__BbYUJF3',
			[
				'label' => __( 'Normal Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-section-title-box .gt-section-title' => 'color: {{VALUE}};',
		 		],


			]
		);


		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_kpscb63',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-section-title-box .gt-section-title',
			]
		);


         $this->end_controls_section();
         // Title Style End
         // Sub Title Style
          $this->start_controls_section(
			'section__85db3fF',
			[
				'label' => __( 'Sub Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

 		$this->add_control(
			'color__Tm2Sv4s',
			[
				'label' => __( 'Normal Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-section-title-box .gt-section-sub-title' => 'color: {{VALUE}};',
		 		],


			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__Tm2Sv4s',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-section-title-box .gt-section-sub-title',
			]
		);



		 $this->end_controls_section();
		  // Sub Title Style End
		 // Description Style Start
		  $this->start_controls_section(
			'section__74ile76',
			[
				'label' => __( 'Description', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
 		$this->add_control(
			'color__74ile76',
			[
				'label' => __( 'Normal Color', 'yog-core' ),

				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-section-title-box .gt-section-description' => 'color: {{VALUE}};',
		 		],


			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__74ile76',
				'label' => __( 'Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-section-title-box .gt-section-description',
			]
		);

		 $this->end_controls_section();
		 // Description Style End
	}

	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/section_title.php';
    }

}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Sectiontitle() );