<?php
namespace Elementor;
if (!defined('ABSPATH')) {
	exit;
}

class progress extends Widget_Base {

	public function get_name() {
		return __('gym-progress', 'yog-core');
	}

	public function get_title() {
		return __('gym Progress', 'yog-core');
	}

	public function get_categories() {
		return ['yog-core'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve button widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-loading';
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'progress_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/radial/1.png', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );
                $this->end_controls_section();

		$this->start_controls_section(
			'section_image',
			[
				'label' => __('Progress', 'yog-core'),
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __('Title', 'yog-core'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('This is Simple Title', 'yog-core'),
				'placeholder' => __('', 'yog-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'sub_title_text',
			[
				'label' => __('Sub Title', 'yog-core'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('This is Simple Sub Title', 'yog-core'),
				'placeholder' => __('', 'yog-core'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'description_text',
			[
				'label' => __('Content', 'yog-core'),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'default' => __('Enter your Description here', 'yog-core'),
				'placeholder' => __('Enter your description', 'yog-core'),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
		);

		$this->add_responsive_control(
			'progress_number',
			[
				'label' => __('Progress Number', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 90,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
			]
		);

		$this->add_responsive_control(
			'size',
			[
				'label' => __('size', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 180,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 1024,
					],
				],
			]
		);
		$this->add_responsive_control(
			'speed',
			[
				'label' => __('speed', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 2000,
				],
				'range' => [
					'px' => [
						'min' => 1000,
						'max' => 5000,
					],
				],
			]
		);

		$this->add_responsive_control(
			'thickness',
			[
				'label' => __('Thickness', 'yog-core'),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 12,
				],
				'range' => [
					'px' => [
						'min' => 10,
						'max' => 100,
					],
				],
			]
		);

		$this->add_control(
			'color',
			[
				'label' => __('Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				'default' => '#7a7a7a',

			]
		);
		$this->add_control(
			'back_color',
			[
				'label' => __('Background Color', 'yog-core'),
				'type' => Controls_Manager::COLOR,
				'default' => '#ffffff',

			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __('Alignment', 'yog-core'),
				'type' => Controls_Manager::CHOOSE,
				'separator' => 'after',
				'default' => 'left',
				'options' => [
					'left' => [
						'title' => __('Left', 'yog-core'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __('Center', 'yog-core'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __('Right', 'yog-core'),
						'icon' => 'eicon-text-align-right',
					],

				],
			]
		);



		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings();
		require YOG_PLUGIN_DIR . '/includes/elementor/render/progress.php';

		if (Plugin::$instance->editor->is_edit_mode()): ?>



			<script>
				(function(jQuery) {
					ToxProgress.create();
					ToxProgress.animate();
				})(jQuery);
				jQuery('.timer').countTo();
			</script>

		<?php endif;
	}

}

Plugin::instance()->widgets_manager->register_widget_type(new \Elementor\progress());