<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Progressbar extends Widget_Base {

	public function get_name() {
		return __( 'yog_progressbar', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Progressbar', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-skill-bar';
	}

	

	protected function _register_controls() {
		$this->start_controls_section(
			'section_rtqCSgd6aLy7Pc23Q5bI',
			[
				'label' => __( 'Progress Bar Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'design_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/process/1.png',  
                				'2' => YOG_PLUGIN_URL.'/assests/img/process/1.png', 
                				'3' => YOG_PLUGIN_URL.'/assests/img/process/1.png',  
                				
                			],
                'description' => __('This is desceiption' , 'yog-core')
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Progressbar', 'yog-core' ),
			]
		);       
        
        $repeater = new Repeater();
        $repeater->add_control(
			'section_title',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __( 'Add Your Title Text Here', 'yog-core' ),
			]
		);	

		$repeater->add_control(
			'tab_score',
			[
				'label' => __( 'Score out of 100', 'yog-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],
				
			]
		);
		 $this->add_control(
			'progress_bar',
			[
				'label' => __( 'Add Progress Bar', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'section_title' => __( 'List Items', 'yog-core' ),
						'tab_score'=>__( '50', 'yog-core' ),
                        
					]
					
				],
				'title_field' => '{{{ section_title }}}',
				'figure_field' => '{{{ tab_score }}}',
			]
        );

		 $this->add_control(
			'yog_has_box_shadow',
			[
				'label' => __( 'Box Shaow?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		 $this->end_controls_section();

		$this->start_controls_section(
			'section_progress_style',
			[
				'label' => __( 'Progress Bar Style', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'progress_back_color',
			[
				'label' => __( 'Progress Bar Background Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [					
					'{{WRAPPER}} .gt-progress-bar' => 'background: {{VALUE}};',
					
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_text_typography',
				'label' => __( 'Title Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-progressbar-box .progress-title',
			]
		);
		

		$this->add_control(
			'title_color',
			[
				'label' => __( 'Title Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-progressbar-box .progress-title' => 'color: {{VALUE}};',
					
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'number_text_typography',
				'label' => __( 'Number Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-progressbar-box .progress-value',
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => __( 'Number Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-progressbar-box .progress-value' => 'color: {{VALUE}};'
					
					
				],
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'flip_back_back',
				'types' => [ 'classic', 'gradient' ],			

				'selector' => '{{WRAPPER}} .gt-progressbar-box .show-progress ,{{WRAPPER}}  .gt-progressbar-style-3 .progress-value, {{WRAPPER}} .gt-progressbar-style-3 .progress-value::before',
				'fields_options' => [
					'background' => [
						'frontend_available' => true,
					]

				],
			]
		);
		
		
	
        $this->add_responsive_control(
			'progressbar_height',
			[
				'label' => __( 'Height', 'yog-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gt-progress-bar' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .gt-progressbar-style-3 .progress-value' => 'margin-top: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		 $this->add_responsive_control(
			'progressbar_border_radius',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gt-progress-bar,{{WRAPPER}} .gt-progress-bar>span' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);
		

		

        $this->end_controls_section();

        


	}
	
	protected function render() {
		$settings = $this->get_settings();
       
         require YOG_PLUGIN_DIR . '/includes/elementor/render/progress-bar.php';
        if ( Plugin::$instance->editor->is_edit_mode() ) {
			
			?>
	
			<script>	
						 /*------------------------
                Progress Bar
                --------------------------*/
                 jQuery('.gt-progress-bar > span').each(function() {
                    
                    var progress_bar = jQuery(this);
                    var width = jQuery(this).data('percent');
                    progress_bar.css({
                        'transition': 'width 2s'
                    });
                    jQuery('.progress-value').css({'transition': 'margin 2s'});

                    setTimeout(function() {
                        jQuery(this).show(function() {
                            progress_bar.css('width', width + '%');
                        });
                    }, 500);

                    setTimeout(function() {
                        jQuery('.gt-progressbar-style-2 .progress-value').show(function() {
                            jQuery('.gt-progressbar-style-2 .progress-value').css('margin-left', width + 'px');
                        });
                    }, 500);

                    setTimeout(function() {
                        jQuery('.gt-progressbar-style-3 .progress-tooltip').show(function() {
                            jQuery('.gt-progressbar-style-3 .progress-tooltip').css('margin-left', width + 'px');
                        });
                    }, 500);
                });
			</script>

		<?php 
		}
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Progressbar() );