<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Process_Step extends Widget_Base {

	public function get_name() {
		return __( 'Process_Step', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Process Step', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-info-box';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);

		$this->add_control(
            'layout_style',
            [
                
                'type' => 'image_select_control',
                'option' => [
                				'1' => YOG_PLUGIN_URL.'/assests/img/process/1.png', 
                				'2' => YOG_PLUGIN_URL.'/assests/img/process/2.png', 
                				
                			],
                'description' => __('This is description' , 'yog-core')
            ]
        );

        $this->end_controls_section();
		$this->start_controls_section(
			'section_image',
			[
				'label' => __( 'Process Step Box', 'yog-core' ),
			]
		);

		
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is sample title', 'yog-core' ),
				'placeholder' => __( 'Enter your title', 'yog-core' ),
				'label_block' => true,
			]
        );

        $this->add_control(
			'title_tag',
			[
				'label' => __( 'Title Tag', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'h5',
				'options' => [
					'h1'  => 'h1',
					'h2'  => 'h2',
					'h3'  => 'h3',
					'h4'  => 'h4',
					'h5'  => 'h5',
					'h6'  => 'h6',
					'p'  => 'p',
					'span'  => 'span',
					
				],
				
			]
			
		);

		$this->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'1'          => __( 'Image', 'yog-core' ),
					'2'          => __( 'Icon', 'yog-core' ),
					
				],
				'condition' => ['layout_style' => "2"]

				
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				'condition' => [
					'image_style' => '1',
				],
			]
		);

		
		

		$this->add_control(
			'icon_class',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => '2',
				],

			]
		);

		 $this->add_control(
			'use_before_img',
			[
				'label'      => __( 'Use Before Image', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'no',
				'options'    => [
					
					'yes'          => __( 'Yes', 'yog-core' ),
					'no'          => __( 'No', 'yog-core' ),
					
				],
				'condition' => ['layout_style' => "2"]
			]
		);

		$this->add_control(
			'arrow_img',
			[
				'label' => __( 'Before Image', 'yog-core' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],			
				
				'condition' => ['use_before_img' => 'yes']
			]
		);

		$this->add_control(
			'description_text',
			[
				'label' => __( 'Content', 'yog-core' ),
				'type' => Controls_Manager::WYSIWYG,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Enter your Description here', 'yog-core' ),
				'placeholder' => __( 'Enter your description', 'yog-core' ),
				'separator' => 'before',
				'rows' => 10,
				'show_label' => true,
			]
		);





		

		$this->add_control(
			'step_number',
			[
				'label' => __( 'Step Number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '1', 'yog-core' ),
				'placeholder' => __( 'Enter Step Number', 'yog-core' ),
				'label_block' => true,
				
			]

        );
		
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gt-process-step' => 'text-align: {{VALUE}}',
				],
			]
		);
        



		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_Jnza43wt8d9QH5b77duo',
			[
				'label' => __( 'Button', 'yog-core' ),
			]
		);
			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';

		//$this->end_controls_section();

		// STLYE


		$this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

         $this->start_controls_tabs( 'tabs__WZbRxd5' );
         $this->start_controls_tab(
            'tabs_eCc902a',
            [
                'label' => __( 'Normal', 'elementor' ),
            ]
        );

         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_kpscb63',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-title',
			]
		);

 		$this->add_control(
			'title_color__BbYUJF3',
			[
				'label' => __( 'TItle Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-title' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'has_border__d2VjaF48',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__d2VjaFs4F4',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__d2VjaF48' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-title' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__d2VjaAF4',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__d2VjaF48' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-process-step .gt-process-title' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__d2VjaQF4',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF48' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-title' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__d2VjaAF4',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF48' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-title' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		

		$this->add_responsive_control(
			'padding__d2VjaGF4',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF48' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__d2VjaF4',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF48' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		// Spacing

		
         $this->end_controls_tab();

         $this->start_controls_tab(
            'tabs_Ax450ea',
            [
                'label' => __( 'Hover', 'elementor' ),
            ]
        );
		$this->add_control(
			'title_color_s3w1o04',
			[
				'label' => __( 'Hover Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-title:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography_e38xupd',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-title:hover',
			]
		);
         $this->end_controls_tab();
         $this->end_controls_tabs();
         $this->end_controls_section();

         // DESCPTION

         
         $this->start_controls_section(
			'section__74ile76',
			[
				'label' => __( 'Description', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
         $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__74ile7s6',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-description',
			]
		);
           $this->add_control(
			'color__74iled76',
			[
				'label' => __( 'Description Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-description' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);$this->add_control(
			'has_border__d2VjaF489',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__d2VjaF4M',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__d2VjaF489' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-description' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__d2VjaF4M',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__d2VjaF489' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-process-step .gt-process-description' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__d2VjaF4M',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF489' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-description' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__d2VjaF4M',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF489' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		

		$this->add_responsive_control(
			'padding__d2VjaF4M',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF489' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__d2VjUaF4M',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'condition' => [
					'has_border__d2VjaF489' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
  		
		$this->end_controls_tab();
         $this->end_controls_tabs();        
		 $this->end_controls_section();
		 $this->start_controls_section(
			'section__005e759',
			[
				'label' => __( 'Icon/Image', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section__005e759');

		$this->start_controls_tab(
			'tab_005e759',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_normal_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-media i',
			]
		);
		
		$this->add_control(
			'normal_text_color__95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-media i' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_responsive_control(
			'font_size_d5e3011',
			[
				'label' => __( 'Font Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-media i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab__95c0470',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-media i:hover',
			]
		);
		$this->add_control(
			'hover_text_color_95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-media i:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'section_CaKGf7taPh49e5fIcmRl',
			[
				'label' => __( 'Icon Border', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		
		$this->start_controls_tabs( '_Rd23fbgiq755Vb4Ysypm' );
		$this->start_controls_tab(
			'tabs_btn__t1kd2dQna3YD7Fba0b35',
			[
				'label' => __( 'Normal', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border__72f3Leb',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__72f3Leb',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__72f3Leb',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__72f3Leb' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-process-step .gt-process-media i' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__72f3Leb',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__72f3Leb',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		//Border Style

		

		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_btn_a5d5136',
			[
				'label' => __( 'Hover', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border_a5d5136',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color_a5d5136',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i:hover' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style_a5d5136',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => ['has_border_a5d5136' => 'yes'],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-process-step .gt-process-media i:hover' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width_a5d5136',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius_a5d5136',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();

		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_fa4eccc',
			[
				'label' => __( 'Icon Spacing', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->add_responsive_control(
			'padding__72f3Leb',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__72f3Leb',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-media i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->end_controls_section();
		$this->start_controls_section(
			'section_14d5362',
			[
				'label' => __( 'Number', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'typography__5aa062a',
				'label' => __( 'Typography', 'yog-core' ),				
				'selector' => '{{WRAPPER}} .gt-process-step .gt-process-number',
			]
		);
		 $this->add_control(
			'color_d63b17b',
			[
				'label' => __( 'Text Color', 'yog-core' ),
				
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-process-step .gt-process-number' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
	  $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'box_background_5950c40',
                'label' => __( 'Background', 'yog-core' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .gt-process-step .gt-process-number',
            ]
        );

	  $this->add_control(
			'has_border_baacd2c',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color_baacd2c',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border_baacd2c' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-number' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style_baacd2c',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => ['has_border_baacd2c' => 'yes'],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-process-step .gt-process-number' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width_baacd2c',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border_baacd2c' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-number' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius_baacd2c',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border_baacd2c' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-process-step .gt-process-number' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->end_controls_section();

		// section background
		$this->start_controls_section(
			'section_style_c7d5251',
			[
				'label' => __( 'Background', 'elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => ['layout_style' => '1']
			]
		);

		$this->start_controls_tabs( 'tabs_background_c7d5251' );

		$this->start_controls_tab(
			'tab_background_normal_c7d5251',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background_c7d5251',
				'types' => [ 'classic', 'gradient', 'slideshow' ],
				'selector' => '{{WRAPPER}} .gt-process-step.gt-process-1',
				'fields_options' => [
					'background' => [
						'frontend_available' => true,
					],
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_background_hover_c7d5251',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background_hover_c7d5251',
				'selector' => '{{WRAPPER}} .gt-process-step.gt-process-1:hover',
			]
		);

		

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		// Section Column Background Overlay.
		$this->start_controls_section(
			'section_background_overlay',
			[
				'label' => __( 'Background Overlay', 'elementor' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => ['layout_style' => '1']
				
			]
		);

		$this->start_controls_tabs( 'tabs_background_overlay' );

		$this->start_controls_tab(
			'tab_background_overlay_normal',
			[
				'label' => __( 'Normal', 'elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background_overlay',
				'selector' => '{{WRAPPER}} .gt-process-step.gt-process-1',
			]
		);

		$this->add_control(
			'background_overlay_opacity',
			[
				'label' => __( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => .5,
				],
				'range' => [
					'px' => [
						'max' => 1,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .gt-process-step.gt-process-1' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'background_overlay_background' => [ 'classic', 'gradient' ],
				],
			]
		);

		

		

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_background_overlay_hover',
			[
				'label' => __( 'Hover', 'elementor' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'background_overlay_hover',
				'selector' => '{{WRAPPER}} .gt-process-step.gt-process-1:hover',
			]
		);

		$this->add_control(
			'background_overlay_hover_opacity',
			[
				'label' => __( 'Opacity', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => .5,
				],
				'range' => [
					'px' => [
						'max' => 1,
						'step' => 0.01,
					],
				],
				'selectors' => [
					'{{WRAPPER}}:hover .gt-process-step.gt-process-1' => 'opacity: {{SIZE}};',
				],
				'condition' => [
					'background_overlay_hover_background' => [ 'classic', 'gradient' ],
				],
			]
		);

		

		

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();




	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/process-step.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Process_Step() );