<?php
namespace Elementor;
if ( ! defined( 'ABSPATH' ) ) exit;
class yog_Price extends Widget_Base {
	public function get_name() {
		return __( 'yog_Price', 'yog-core' );
	}
	public function get_title() {
		return __( 'Pricing Plan', 'yog-core' );
	}
	public function get_categories() {
		return [ 'yog-core' ];
	}
	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-price-table';
	}
	protected function _register_controls() {
			$this->start_controls_section(
			'section',
			[
				'label' => __( 'Style', 'yog-core' ),
			]
		);
		$this->add_control(
            'price_style',
            [
                'label' => __( 'Select Style', 'plugin-domain' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1'  => __( 'Style 1', 'plugin-domain' ),
					'2' => __( 'Style 2', 'plugin-domain' ),
				],
            ]
        );
        $this->end_controls_section();
		$this->start_controls_section(
			'section_imge',
			[
				'label' => __( 'Pricing Plan', 'yog-core' ),
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __( 'Your  Title Here', 'yog-core' ),
			]
		);
		$this->add_control(
			'month',
			[
				'label' => __( 'Permonth', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __( 'Your Per Month Here', 'yog-core' ),
			]
		);
        $this->add_control(
			'price',
			[
				'label' => __( 'Price', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __( 'Your price Here', 'yog-core' ),
			]
		);
		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',
					'library' => 'fa-solid',
				],
				 'condition' => [
					'price_style' => '2',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
			]
		);
		 $this->add_control(
			'icontitle',
			[
				'label' => __( 'Icon Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
                'condition' => [
					'price_style' => '2',
				],
				'label_block' => true,
				'default' => __( 'Your Icon  Title Here', 'yog-core' ),
			]
		);

		 $this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'interior-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				 'condition' => [
					'price_style' => '1',
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		); 


		$this->add_control(
			'active',
			[
				'label' => __( 'Is Active?', 'elementor' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'label_off',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
		);
        $repeater = new Repeater();
        $repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Plan info List', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'List Item', 'yog-core' ),
				'placeholder' => __( 'List Item', 'yog-core' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'select_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-android-arrow-dropright',
					'library' => 'fa-solid',
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
			]
		);
		$repeater->add_control(
			'class_on',
			[
				'label' => __( 'Enable/disable class', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER ,
				'label_on' => __( 'Show', 'yog-core' ),
				'label_off' => __( 'Hide', 'yog-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$repeater->add_control(
			'hide_title',
			[
				'label' => __( 'Enable/disable', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER ,
				'label_on' => __( 'Show', 'yog-core' ),
				'label_off' => __( 'Hide', 'yog-core' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
        $this->add_control(
			'tabs',
			[
				'label' => __( 'List Items', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'Tab #1', 'yog-core' ),
						'hide_title' => __( 'Show', 'yog-core' ),
					]
				],
				'title_field' => '{{{ tab_title }}}',
			]
		);
		$this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					],
					'text-justify' => [
						'title' => __( 'Justified', 'yog-core' ),
						'icon' => 'eicon-text-align-justify',
					],
				]
			]
		);
        $this->end_controls_section();
           $this->start_controls_section(
			'section__2p08cZ1',
			[
				'label' => __( 'Colors', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'icon_colors',
			[
				'label' => __( 'Icon Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-pricebox.gt-pricebox-style-1 .gt-service-media i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label .icon-list-icon i' => 'color: {{VALUE}};',
		 		],
			]
		);
        $this->add_control(
			'title_color',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h2.gt-price-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} span.gt-price-title' => 'color: {{VALUE}};',
		 		],
			]
		);
		$this->add_control(
			'price_color',
			[
				'label' => __( 'Price Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} h2.price' => 'color: {{VALUE}};'
		 		],
			]
		);
		$this->add_control(
			'permonth_color',
			[
				'label' => __( 'Permonth Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} span.permonth' => 'color: {{VALUE}};',
					'{{WRAPPER}} p.gt-price-duration' => 'color: {{VALUE}};',
		 		],
			]
		);
         $this->add_control(
			'listicon_colors',
			[
				'label' => __( 'List Icon Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-pricebox.gt-pricebox-style-1 .icon-list-icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-list-info li.active i' => 'color: {{VALUE}};',
		 		],
			]
		);
        $this->add_control(
			'listtitle_color',
			[
				'label' => __( 'List Title', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li.icon-list-item span' => 'color: {{VALUE}};',
					'{{WRAPPER}} li.active' => 'color: {{VALUE}};',
		 		],
			]
		);
          $this->add_control(
			'icontitle_color',
			[
				'label' => __( 'Icon Title', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label' => 'color: {{VALUE}};',
		 		],
			]
		);
          $this->add_control(
			'bgtitle_color',
			[
				'label' => __( 'Background Icontitle', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label' => 'background-color: {{VALUE}};',
		 		],
			]
		);
		 $this->end_controls_section();
		  $this->start_controls_section(
			'section__2p08Z1',
			[
				'label' => __( 'Typography', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icon_typography',
				'label' => __( 'Icon', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-pricebox.gt-pricebox-style-1 .gt-service-media i',
				              '{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label .icon-list-icon i',
			]
		);
		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Title', 'yog-core' ),
				'selector' => '{{WRAPPER}} h2.gt-price-title',
				               '{{WRAPPER}} span.gt-price-title',
			]
		);
		  $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'price_typography',
				'label' => __( 'Price', 'yog-core' ),
				'selector' => '{{WRAPPER}} h2.price',
			]
		);
		   $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'permonth_typography',
				'label' => __( 'Permonth Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} span.permonth' ,
				              '{{WRAPPER}} p.gt-price-duration' ,
			]
		);
		   $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'listicon_typography',
				'label' => __( 'List Icon Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-pricebox.gt-pricebox-style-1 .icon-list-icon i' ,
				              '{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-list-info li.active i' ,
			]
		);
		   $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'listtitle_typography',
				'label' => __( 'List Title Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} li.icon-list-item span' ,
				              '{{WRAPPER}} li.active' ,
			]
		);
		 $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'icontitle_typography',
				'label' => __( 'Icontitle Icon Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label' ,
			]
		);
		   $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'bgicon_typography',
				'label' => __( 'Background label Typography', 'yog-core' ),
				'selector' => '{{WRAPPER}} .gt-pricebox-2.gt-pricebox-style-2 .gt-price-label' ,
			]
		);
		 $this->end_controls_section();
        $this->start_controls_section(
			'section_Jnza43wt8d9QH5b77duo',
			[
				'label' => __( 'Button', 'yog-core' ),
			]
		);
			require YOG_PLUGIN_DIR . '/includes/elementor/common/btn_controls.php';
		//$this->end_controls_section();
	}
	protected function render() {
		$settings = $this->get_settings();
        require  YOG_PLUGIN_DIR . '/includes/elementor/render/price.php';
    }
}
Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Price() );