<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Portfolio extends Widget_Base {

	public function get_name() {
		return __( 'portfolio', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'portfolio', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-portfolio-carousel';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'portfolio', 'yog-core' ),
			]
		);

		// $this->add_control(
		// 	'image_style',
		// 	[
		// 		'label' => __('Choose Image/Icon', 'yog-core'),
		// 		'type' => Controls_Manager::SELECT,
		// 		'default' => 'none',
		// 		'options' => [
		// 			'none' => __('None', 'yog-core'),
		// 			'1' => __('Image', 'yog-core'),
		// 			'2' => __('Icon', 'yog-core'),

		// 		],
				
		// 	]
		// );

		// $this->add_control(
		// 	'image',
		// 	[
		// 		'label' => __('Choose Image', 'yog-core'),
		// 		'type' => Controls_Manager::MEDIA,
		// 		'dynamic' => [
		// 			'active' => true,
		// 		],
				
		// 		'condition' => [
		// 			'image_style' => '1',
		// 		],
		// 	]
		// );

		

		// $this->add_control(
		// 	'selected_icon',
		// 	[
		// 		'label' => __('Icon', 'yog-core'),
		// 		'type' => Controls_Manager::ICONS,
		// 		'label_block' => true,
		// 		'default' => [
		// 			'value' => 'ion ion-android-add',
					
		// 		],
		// 		'fa4compatibility' => 'icon',
		// 		'separator' => 'before',
		// 		'condition' => [
		// 			'image_style' => '2',
		// 		],
		// 	]
		// );
		$this->add_control('crop_images',
            array(
                'label'        => esc_html__('Crop Images','thegov-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'true'     => esc_html__( 'yes', 'thegov-core' ),
                'false'    => esc_html__( 'no', 'thegov-core' ),
                'return_value' => 'true',
                
            )
        );
        $this->add_control(
			'crop_height',
			[
				'label' => __( 'height', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Image height', 'koncpt-core' ),
				'label_block' => true,
				'condition' => [
					'crop_images' => 'true',
				],
			]
		);
		$this->add_control(
			'crop_weight',
			[
				'label' => __( 'weight', 'koncpt-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Image weight', 'koncpt-core' ),
				'label_block' => true,
				'condition' => [
					'crop_images' => 'true',
				],

			]
		);
		

		$this->add_control(
			'desk_num',
			[
				'label' => __( 'Desktop number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'yog-core' ),				
				'separator' => 'before',
				
			]
        );
        $this->add_control(
			'lap_num',
			[
				'label' => __( 'Laptop number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '3', 'yog-core' ),				
				'separator' => 'before',
				
			]
        );

        $this->add_control(
			'tab_num',
			[
				'label' => __( 'Tablet number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '2', 'yog-core' ),				
				'separator' => 'before',
				
			]
        );

        $this->add_control(
			'mob_num',
			[
				'label' => __( 'Mobile number', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( '1', 'yog-core' ),				
				'separator' => 'before',
				
			]
        );

        $this->add_control(
			'autoplay',
			[
				'label'      => __( 'Autoplay', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'False'          => __( 'False', 'yog-core' ),				
					
				],
				
			]
		);
		$this->add_control(
			'loop',
			[
				'label'      => __( 'Loop', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'False'          => __( 'False', 'yog-core' ),				
					
				],
				
			]
		);

		$this->add_control(
			'nav_arrow',
			[
				'label'      => __( 'Navigation Arrow', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				
			]
		);
		$this->add_control(
			'dots',
			[
				'label'      => __( 'Dots', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'true',
				'options'    => [
					'true'       => __( 'True', 'yog-core' ),
					'false'          => __( 'False', 'yog-core' ),				
					
				],
				
			]
		);

		$this->add_responsive_control(
			'margin',
			[
				'label' => __( 'Space', 'elementor' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 30,
				],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				
			]
		);


		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
                'default' => __( 'left', 'yog-core' ),
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio' => 'text-align: {{VALUE}}',
				],
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'section__194d0c0',
			[
				'label' => __( 'Portfolio Info', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section_267d1eb' );

		$this->start_controls_tab(
			'tab_194d0c0',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'normal_back_color_005e759',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-portfolio .gt-portfolio-info',
			]
		);
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab__267d1eb',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'hover_back_color_005e759',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-portfolio .gt-portfolio-info:hover',
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();

        $this->end_controls_section();
        $this->start_controls_section(
			'section__b077470',
			[
				'label' => __( 'Category', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section_b077470');

		$this->start_controls_tab(
			'tab_267d1eb',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		
		$this->add_control(
			'normal_text_color_67d0c50',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio span' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_kpscb63',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);
		
		$this->add_control(
			'hover_text_color_67d0c50',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio span:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'section__ce57701',
			[
				'label' => __( 'Title', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section_ce57701');

		$this->start_controls_tab(
			'tab_ce57701',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		
		$this->add_control(
			'normal_text_color__5674970',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio .gt-portfolio-title a' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_5674970',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);
		
		$this->add_control(
			'hover_text_color_5674970',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio .gt-portfolio-title a:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();
		$this->start_controls_section(
			'section__005e759',
			[
				'label' => __( 'Icon/Image', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section__005e759');

		$this->start_controls_tab(
			'tab_005e759',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_normal_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a',
			]
		);
		
		$this->add_control(
			'normal_text_color__95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a i' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab__95c0470',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a:hover',
			]
		);
		$this->add_control(
			'hover_text_color_95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a i:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section(
			'section_CaKGf7taPh49e5fIcmRl',
			[
				'label' => __( 'Icon Border', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		
		$this->start_controls_tabs( '_Rd23fbgiq755Vb4Ysypm' );
		$this->start_controls_tab(
			'tabs_btn__t1kd2dQna3YD7Fba0b35',
			[
				'label' => __( 'Normal', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border__72f3Leb',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__72f3Leb',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__72f3Leb',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__72f3Leb' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__72f3Leb',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__72f3Leb',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		//Border Style

		

		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_btn_a5d5136',
			[
				'label' => __( 'Hover', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border_a5d5136',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color_a5d5136',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a:hover' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style_a5d5136',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => ['has_border_a5d5136' => 'yes'],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-portfolio .gt-portfolio-block .gt-portfolio-img a:hover' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width_a5d5136',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius_a5d5136',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();

		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_fa4eccc',
			[
				'label' => __( 'Icon Spacing', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->add_responsive_control(
			'padding__72f3Leb',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__72f3Leb',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-portfolio .gt-portfolio-block .gt-portfolio-img a i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/portfolio.php' ;

        
         if ( Plugin::$instance->editor->is_edit_mode() ) : ?>



		<script>	
		jQuery('.owl-carousel').each(function() {
           var app_slider = jQuery(this);
          
          
           
           app_slider.owlCarousel({
               items: app_slider.data("desk_num"),
               loop: app_slider.data("loop"),
               margin: app_slider.data("margin"),
               nav: app_slider.data("nav"),
               dots: app_slider.data("dots"),
               autoplay: app_slider.data("autoplay"),
               autoplayTimeout: app_slider.data("autoplay-timeout"),
               navText: ["<i class='ion-ios-arrow-back'></i><span>Prev</span>", "<span>Next</span><i class='ion-ios-arrow-forward'></i>"],
               responsiveClass: true,
               responsive: {
                   // breakpoint from 0 up
                   0: {
                       items: app_slider.data("mob_sm"),
                       nav: false,
                       dots: true
                   },
                   // breakpoint from 480 up
                   480: {
                       items: app_slider.data("mob_num"),
                       nav: false,
                       dots: true
                   },
                   // breakpoint from 786 up
                   786: {
                       items: app_slider.data("tab_num")
                   },
                   // breakpoint from 1023 up
                   1023: {
                       items: app_slider.data("lap_num")
                   },
                   1199: {
                       items: app_slider.data("desk_num")
                   }
               }
           });
       });
		</script>
		
		<?php endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Portfolio() );