<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Portfolio_info extends Widget_Base {

	public function get_name() {
		return __( 'yog_portfolio_info', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Portfolio Info', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
	}


	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-editor-list-ul';
	}
	protected function _register_controls() {
		$this->start_controls_section(
			'list_section',
			[
				'label' => __( 'Portfolio Info', 'yog-core' ),
			]
		);

		
		$this->add_control(
			'list_main_item_title',
			[
				'label' => __( 'Main Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'List Item', 'yog-core' ),
				'default' => __( 'List Item', 'yog-core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$this->add_control(
			'info_description',
			[
				'label' => __( 'Description', 'yog-core' ),
				'type' => Controls_Manager::TEXTAREA,
				'label_block' => true,
				'placeholder' => __( 'List Item', 'yog-core' ),				
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater = new Repeater();

        $repeater->add_control(
			'list_item_title',
			[
				'label' => __( 'Title', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'List Item', 'yog-core' ),
				'default' => __( 'List Item', 'yog-core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);

		$repeater->add_control(
			'list_item_sub_title',
			[
				'label' => __( 'Info', 'yog-core' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'List Item', 'yog-core' ),
				'default' => __( 'List Item', 'yog-core' ),
				'dynamic' => [
					'active' => true,
				],
			]
		);

		 $this->add_control(
			'list',
			[
				'label' => __( 'List', 'yog-core' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'list_item' => __( 'List 1', 'yog-core' ),
						
					]
					
				]
			]
		);
		
		
        
        
       

		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/portfolio-info.php';
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Portfolio_info() );