<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Portfolio_grid extends Widget_Base {

	public function get_name() {
		return __( 'portfolio-grid', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'portfolio Grid', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-portfolio-carousel';
	}

	protected function _register_controls() {
		$this->start_controls_section(
			'section_slider',
			[
				'label' => __( 'portfolios', 'yog-core' ),
			]
		);
		$this->add_control(
			'show_filter',
			[
				'label' => __( 'Show Filter-bar', 'plugin-domain' ),
				'type' => Controls_Manager::SWITCHER,
				'block' => __( 'Show', 'your-plugin' ),
				'none' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'none',
				// 'default' => 'none',

				'selectors' => [
						'{{WRAPPER}} .gt-filters .filters' => 'display: {{VALUE}};',
						
					],
				
			]
		);
		$this->add_control(
			'no_padding',
			[
				'label' => __( 'No padding', 'plugin-domain' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'your-plugin' ),
				'label_off' => __( 'Hide', 'your-plugin' ),
				'return_value' => 'no-padding',
				
			]
		);
		$this->add_control('crop_images',
            array(
                'label'        => esc_html__('Crop Images','thegov-core' ),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'On', 'thegov-core' ),
                'label_off'    => esc_html__( 'Off', 'thegov-core' ),
                'return_value' => false,
                
            )
        );
	
	$this->add_control(
			'hide_load_more',
			[
				'label' => __( 'Hide Load More', 'plugin-domain' ),
				'type' => Controls_Manager::SWITCHER,
				'none' => __( 'yes', 'your-plugin' ),
				'block' => __( 'no', 'your-plugin' ),
				'return_value' => 'none',
				'selectors' => [
						'{{WRAPPER}} .gt-btn-load-container' => 'display: {{VALUE}};',
						
					],
				
			]
		);
$this->add_control(
			'grid_style',
				[
					'label' => __( 'Grid Style', 'yog-core' ),					
					'type' => Controls_Manager::SELECT,
					'default' => 'gt-col-3',					
					'options' => [
						'gt-col-6'  => __( 'Two Column', 'yog-core' ),
						'gt-col-4'  => __( 'Three Column', 'yog-core' ),
						'gt-col-3'  => __( 'Four Column', 'yog-core' ),
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-button' => 'border-style: {{VALUE}};',
						
					],
				]
		);
	$this->add_control(
			'initial_items',
			[
				'label' => __( 'Number Item To Show', 'plugin-domain' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,				
				'step' => 1,
				'default' => 5,
			]
		);

	$this->add_control(
			'next_items',
			[
				'label' => __( 'Number Of Item To Load', 'plugin-domain' ),
				'type' => Controls_Manager::NUMBER,
				'min' => 1,				
				'step' => 1,
				'default' => 5,
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
                'default' => __( 'left', 'yog-core' ),
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gt-portfolio' => 'text-align: {{VALUE}}',
				],
			]
		);
        
        $this->end_controls_section();
         $this->start_controls_section(
			'section_Jnza43wt8d9QH5b77d',
			[
				'label' => __( 'Load More Button', 'interier-core' ),
				'condition' => [ 'hide_load_more!' => 'none' ],

			]
		);
         $this->add_control(
			'laod_more_text',
			[
				'label' => __( 'Button Text', 'interier-core' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'Load More', 'interier-core' ),
				'placeholder' => __( 'Enter your title', 'interier-core' ),
				'label_block' => true,
			]
        );

         $this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/portfolio-grid.php' ;

        
         if ( Plugin::$instance->editor->is_edit_mode() ) : ?>



		<script>	
		 

		jQuery('.gt-masonry').isotope({
          itemSelector: '.gt-masonry-item',      
            masonry: {
              columnWidth: '.grid-sizer',
              gutter: 0
              
            }
           
      });

      jQuery('.gt-grid').isotope({
          itemSelector: '.gt-grid-item',
      });

       jQuery('.gt-filter-button-group').on( 'click', '.gt-filter-btn', function() {
        
        var filterValue = jQuery(this).attr('data-filter');
        jQuery('.gt-masonry').isotope({ filter: filterValue });
        jQuery('.gt-grid').isotope({ filter: filterValue });
        jQuery('.gt-filter-button-group .gt-filter-btn').removeClass('active');
        jQuery(this).addClass('active');
        
        
        updateFilterCounts();

      });

	var initial_items = 5;
       var next_items = 3;
	
	if(jQuery('.gt-masonry').length > 0)
		{
			var initial_items = jQuery('.gt-masonry').data('initial_items');
			var next_items = jQuery('.gt-masonry').data('next_items');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			var initial_items = jQuery('.gt-grid').data('initial_items');
			var next_items = jQuery('.gt-grid').data('next_items');
		}

	function showNextItems(pagination) {
		var itemsMax = jQuery('.visible_item').length;
		var itemsCount = 0;
		jQuery('.visible_item').each(function () {
			if (itemsCount < pagination) {
				jQuery(this).removeClass('visible_item');
				itemsCount++;
			}
		});
		if (itemsCount >= itemsMax) {
			jQuery('#showMore').hide();
		}
		
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}

		
		
	}
	// function that hides items when page is loaded
	function hideItems(pagination) {
		var itemsMax = jQuery('.gt-filter-items').length;
		console.log(itemsMax);
		var itemsCount = 0;
		jQuery('.gt-filter-items').each(function () {
			if (itemsCount >= pagination) {
				jQuery(this).addClass('visible_item');
			}
			itemsCount++;
		});
		if (itemsCount < itemsMax || initial_items >= itemsMax) {
			jQuery('#showMore').hide();
		}
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}
	}
	jQuery('#showMore').on('click', function (e) {
		e.preventDefault();
		showNextItems(next_items);
	});
	hideItems(initial_items);

	function updateFilterCounts() {
		// get filtered item elements
		if(jQuery('.gt-masonry').length > 0)
		{
			var itemElems = jQuery('.gt-masonry').isotope('getFilteredItemElements');
		}
		if(jQuery('.gt-grid').length > 0)
		{
			var itemElems = jQuery('.gt-grid').isotope('getFilteredItemElements');
		}
		

		var count_items = jQuery(itemElems).length;
		console.log(count_items);

		if (count_items > initial_items) {
			jQuery('#showMore').show();
		} else {
			jQuery('#showMore').hide();
		}
		if (jQuery('.gt-filter-items').hasClass('visible_item')) {
			jQuery('.gt-filter-items').removeClass('visible_item');
		}
		var index = 0;

		jQuery(itemElems).each(function () {
			if (index >= initial_items) {
				jQuery(this).addClass('visible_item');
			}
			index++;
		});
		if(jQuery('.gt-masonry').length > 0)
		{
			jQuery('.gt-masonry').isotope('layout');
		}

		if(jQuery('.gt-grid').length > 0)
		{
			jQuery('.gt-grid').isotope('layout');
		}
	}
    
		</script>
		
		<?php endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Portfolio_grid() );