<?php
namespace Elementor; 
if ( ! defined( 'ABSPATH' ) ) exit; 

class yog_Popup_video extends Widget_Base {

	public function get_name() {
		return __( 'Popup_video', 'yog-core' );
	}
	
	public function get_title() {
		return __( 'Popup video', 'yog-core' );
	}

	public function get_categories() {
		return [ 'yog-core' ];
    }
    
	/**
	 * Get widget icon.
	 *
	 * Retrieve counter widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-Popup_video-carousel';
	}

	protected function _register_controls() {
		

		$this->start_controls_section(
			'section_video',
			[
				'label' => __( 'Popup_video', 'yog-core' ),
			]
		);

		$this->add_control(
			'image_style',
			[
				'label'      => __( 'Choose Image/Icon', 'yog-core' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'none',
				'options'    => [
					'none'       => __( 'None', 'yog-core' ),
					'image'          => __( 'Image', 'yog-core' ),
					'icon'          => __( 'Icon', 'yog-core' ),
					
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'yog-core'),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				
				'condition' => [
					'image_style' => 'image',
				],
			]
		);

		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'type' => Controls_Manager::ICONS,
				'label_block' => true,
				'default' => [
					'value' => 'ion ion-play',
					
				],
                'fa4compatibility' => 'icon',
				'separator' => 'before',
				'condition' => [
					'image_style' => 'icon',
				]
			]
		);
		$this->add_control(
			'video_type',
			[
				'label' => __( 'Source', 'yog-core' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'video_link',
				'options' => [
					'video_link' => __( 'Link', 'yog-core' ),					
					'hosted' => __( 'Self Hosted', 'yog-core' ),
				],
			]
		);

		$this->add_control(
			'self_url',
			[
				'label' => __( 'Choose File', 'yog-core' ),
				'type' => Controls_Manager::MEDIA,
				
				'media_type' => 'video',
				'condition' => [
					'video_type' => 'hosted',					
				],
			]
		);

		$this->add_control(
			'link_url',
			[
				'label' => __( 'Link', 'yog-core' ),
				'type' => Controls_Manager::TEXT,				
				'placeholder' => __( 'Enter your URL', 'yog-core' ),
				'default' => 'https://www.youtube.com/watch?v=XHOmBV4js_E',
				'label_block' => true,
				'condition' => [
					'video_type' => 'video_link',
				],
			]
		);
		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'yog-core' ),
                'type' => Controls_Manager::CHOOSE,
                'separator' => 'after',
                'default' => __( 'left', 'yog-core' ),
				'options' => [
					'left' => [
						'title' => __( 'Left', 'yog-core' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'yog-core' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'yog-core' ),
						'icon' => 'eicon-text-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .gt-popup-video-block' => 'text-align: {{VALUE}}',
				],
			]
		);
        
        $this->end_controls_section();

        $this->start_controls_section(
			'section__005e759',
			[
				'label' => __( 'Icon', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->start_controls_tabs( 'tabs_section__005e759');

		$this->start_controls_tab(
			'tab_005e759',
			[
				'label' => __( 'Normal', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_normal_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-popup-video-block .gt-video-icon a',
			]
		);
		
		$this->add_control(
			'normal_text_color__95c0470',
			[
				'label' => __( 'Choose Icon Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-popup-video-block .gt-video-icon a i' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);

		 $this->add_responsive_control(
			'font_size_5128324387',
			[
				'label' => __( 'Icon Size', 'plugin-domain' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				
				'selectors' => [
					'{{WRAPPER}} .gt-popup-video-block .gt-video-icon a i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab__95c0470',
			[
				'label' => __( 'Hover', 'yog-core' ),
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'btn_hover_data_background',
				'label' => __( 'Background', 'yog-core' ),
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .gt-popup-video-block .gt-video-icon a:hover',
			]
		);
		$this->add_control(
			'hover_text_color_95c0470',
			[
				'label' => __( 'Choose Color', 'yog-core' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .gt-popup-video-block .gt-video-icon a:hover' => 'color: {{VALUE}};',
		 		],
				
				
			]
		);
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		 $this->start_controls_section(
			'section_CaKGf7taPh49e5fIcmRl',
			[
				'label' => __( 'Icon Border', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		
		$this->start_controls_tabs( '_Rd23fbgiq755Vb4Ysypm' );
		$this->start_controls_tab(
			'tabs_btn__t1kd2dQna3YD7Fba0b35',
			[
				'label' => __( 'Normal', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border__72f3Leb',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color__72f3Leb',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style__72f3Leb',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => [
					'has_border__72f3Leb' => 'yes',					],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',
					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-popup-video-block .gt-video-icon a' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width__72f3Leb',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius__72f3Leb',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border__72f3Leb' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	
		//Border Style

		

		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_btn_a5d5136',
			[
				'label' => __( 'Hover', 'yog-core' ),
				
			]
		);
		$this->add_control(
			'has_border_a5d5136',
			[
				'label' => __( 'Set Custom Border?', 'yog-core' ),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __( 'yes', 'yog-core' ),
				'no' => __( 'no', 'yog-core' ),
			]
        );

		$this->add_control(
			'border_color_a5d5136',
			[
				'label' => __( 'Border Color', 'yog-core' ),				
				'type' => Controls_Manager::COLOR,
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a:hover' => 'border-color: {{VALUE}};',
		 		],
				
				
			]
		);

		$this->add_control(
			'border_style_a5d5136',
				[
					'label' => __( 'Border Style', 'yog-core' ),
					'condition' => ['has_border_a5d5136' => 'yes'],
					'type' => Controls_Manager::SELECT,
					'default' => 'none',					
					'options' => [
						'solid'  => __( 'Solid', 'yog-core' ),
						'dashed' => __( 'Dashed', 'yog-core' ),
						'dotted' => __( 'Dotted', 'yog-core' ),
						'double' => __( 'Double', 'yog-core' ),
						'outset' => __( 'outset', 'yog-core' ),
						'groove' => __( 'groove', 'yog-core' ),
						'ridge' => __( 'ridge', 'yog-core' ),
						'inset' => __( 'inset', 'yog-core' ),
						'hidden' => __( 'hidden', 'yog-core' ),
						'none' => __( 'none', 'yog-core' ),
						
					],
					
					'selectors' => [
						'{{WRAPPER}} .gt-popup-video-block .gt-video-icon a:hover' => 'border-style: {{VALUE}};',
						
					],
				]
		);

		$this->add_control(
			'border_width_a5d5136',
			[
				'label' => __( 'Border Width', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_control(
			'border_radius_a5d5136',
			[
				'label' => __( 'Border Radius', 'yog-core' ),
				'condition' => [
					'has_border_a5d5136' => 'yes',
					],
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	

		$this->end_controls_tab();

		$this->end_controls_tabs();

		
		$this->end_controls_section();

		$this->start_controls_section(
			'section_fa4eccc',
			[
				'label' => __( 'Icon Spacing', 'yog-core' ),
				'tab' => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->add_responsive_control(
			'padding__72f3Leb',
			[
				'label' => __( 'Padding', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'margin__72f3Leb',
			[
				'label' => __( 'Margin', 'yog-core' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .gt-popup-video-block .gt-video-icon a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);
		$this->end_controls_section();
	}
	
	protected function render() {
		$settings = $this->get_settings();
        require YOG_PLUGIN_DIR . '/includes/elementor/render/popup_video.php' ;

        
         if ( Plugin::$instance->editor->is_edit_mode() ) : ?>



		<script>	
		 jQuery('.popup-youtube, .popup-vimeo, .popup-gmaps, .button-play').magnificPopup({
        type: 'iframe',
        mainClass: 'mfp-fade',
        preloader: true,
    });
		</script>
		
		<?php endif; 
    }	    
		
}

Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\yog_Popup_video() );